/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.renderer;

import java.nio.FloatBuffer;
import java.util.Collections;
import lunatrius.schematica.Settings;
import lunatrius.schematica.renderer.RenderHelper;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import lunatrius.schematica.renderer.RendererSchematicChunkSorter;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RendererSchematicGlobal {
    private final Settings settings = Settings.instance();
    private final la profiler;
    private final bgj frustrum;
    private final RendererSchematicChunkSorter rendererSchematicChunkSorter;

    public RendererSchematicGlobal() {
        this.profiler = this.settings.minecraft.J;
        this.frustrum = new bgj();
        this.rendererSchematicChunkSorter = new RendererSchematicChunkSorter();
    }

    @ForgeSubscribe
    public void onRender(RenderWorldLastEvent event) {
        bdv player;
        if (this.settings.minecraft != null && (player = this.settings.minecraft.g) != null) {
            this.settings.playerPosition.x = (float)(player.U + (player.u - player.U) * (double)event.partialTicks);
            this.settings.playerPosition.y = (float)(player.V + (player.v - player.V) * (double)event.partialTicks);
            this.settings.playerPosition.z = (float)(player.W + (player.w - player.W) * (double)event.partialTicks);
            this.settings.rotationRender = kx.c((double)(player.A / 90.0f)) & 3;
            this.settings.orientation = this.getOrientation((sq)player);
            this.profiler.a("schematica");
            if (this.settings.isRenderingSchematic || this.settings.isRenderingGuide) {
                this.render();
            }
            this.profiler.b();
        }
    }

    private int getOrientation(sq player) {
        if (player.B < -45.0f) {
            return 1;
        }
        if (player.B > 45.0f) {
            return 0;
        }
        switch (kx.c((double)((double)player.A / 90.0 + 0.5)) & 3) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    private void render() {
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)(-this.settings.getTranslationX()), (float)(-this.settings.getTranslationY()), (float)(-this.settings.getTranslationZ()));
        this.profiler.a("schematic");
        if (this.settings.isRenderingSchematic) {
            this.profiler.a("updateFrustrum");
            this.updateFrustrum();
            this.profiler.c("sortAndUpdate");
            if (RendererSchematicChunk.getCanUpdate()) {
                this.sortAndUpdate();
            }
            this.profiler.c("render");
            for (int pass = 0; pass < 3; ++pass) {
                for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                    renderer.render(pass);
                }
            }
            this.profiler.b();
        }
        this.profiler.c("guide");
        RenderHelper.createBuffers();
        this.profiler.a("dataPrep");
        if (this.settings.isRenderingSchematic) {
            RenderHelper.drawCuboidOutline(RenderHelper.VEC_ZERO, this.settings.schematic.dimensions(), 63, 0.75f, 0.0f, 0.75f, 0.25f);
        }
        if (this.settings.isRenderingGuide) {
            Vector3f start = new Vector3f();
            Vector3f end = new Vector3f();
            Vector3f.sub((Vector3f)this.settings.pointMin, (Vector3f)this.settings.offset, (Vector3f)start);
            Vector3f.sub((Vector3f)this.settings.pointMax, (Vector3f)this.settings.offset, (Vector3f)end);
            end.translate(1.0f, 1.0f, 1.0f);
            RenderHelper.drawCuboidOutline(start, end, 63, 0.0f, 0.75f, 0.0f, 0.25f);
            Vector3f.sub((Vector3f)this.settings.pointA, (Vector3f)this.settings.offset, (Vector3f)start);
            Vector3f.sub((Vector3f)this.settings.pointA, (Vector3f)this.settings.offset, (Vector3f)end);
            end.translate(1.0f, 1.0f, 1.0f);
            RenderHelper.drawCuboidOutline(start, end, 63, 0.75f, 0.0f, 0.0f, 0.25f);
            RenderHelper.drawCuboidSurface(start, end, 63, 0.75f, 0.0f, 0.0f, 0.25f);
            Vector3f.sub((Vector3f)this.settings.pointB, (Vector3f)this.settings.offset, (Vector3f)start);
            Vector3f.sub((Vector3f)this.settings.pointB, (Vector3f)this.settings.offset, (Vector3f)end);
            end.translate(1.0f, 1.0f, 1.0f);
            RenderHelper.drawCuboidOutline(start, end, 63, 0.0f, 0.0f, 0.75f, 0.25f);
            RenderHelper.drawCuboidSurface(start, end, 63, 0.0f, 0.0f, 0.75f, 0.25f);
        }
        int quadCount = RenderHelper.getQuadCount();
        int lineCount = RenderHelper.getLineCount();
        if (quadCount > 0 || lineCount > 0) {
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)1.5f);
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            this.profiler.c("quad");
            if (quadCount > 0) {
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getQuadVertexBuffer());
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getQuadColorBuffer());
                GL11.glDrawArrays((int)7, (int)0, (int)quadCount);
            }
            this.profiler.c("line");
            if (lineCount > 0) {
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getLineVertexBuffer());
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getLineColorBuffer());
                GL11.glDrawArrays((int)1, (int)0, (int)lineCount);
            }
            this.profiler.b();
            GL11.glDisableClientState((int)32886);
            GL11.glDisableClientState((int)32884);
            GL11.glEnable((int)3553);
        }
        this.profiler.b();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void updateFrustrum() {
        this.frustrum.a((double)this.settings.getTranslationX(), (double)this.settings.getTranslationY(), (double)this.settings.getTranslationZ());
        for (RendererSchematicChunk rendererSchematicChunk : this.settings.sortedRendererSchematicChunk) {
            rendererSchematicChunk.isInFrustrum = this.frustrum.a(rendererSchematicChunk.getBoundingBox());
        }
    }

    private void sortAndUpdate() {
        Collections.sort(this.settings.sortedRendererSchematicChunk, this.rendererSchematicChunkSorter);
        for (RendererSchematicChunk rendererSchematicChunk : this.settings.sortedRendererSchematicChunk) {
            if (!rendererSchematicChunk.getDirty()) continue;
            rendererSchematicChunk.updateRenderer();
            break;
        }
    }
}

