/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.renderer;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import lunatrius.schematica.renderer.RenderHelper;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RendererSchematicChunk {
    public static final int CHUNK_WIDTH = 16;
    public static final int CHUNK_HEIGHT = 16;
    public static final int CHUNK_LENGTH = 16;
    private static boolean canUpdate = false;
    public boolean isInFrustrum = false;
    public final Vector3f centerPosition = new Vector3f();
    private final Settings settings = Settings.instance();
    private final Minecraft minecraft;
    private final la profiler;
    private final SchematicWorld schematic;
    private final List tileEntities;
    private final aqx boundingBox;
    private static final Map texturePacks = new HashMap();
    private boolean needsUpdate;
    private int glList;

    public RendererSchematicChunk(SchematicWorld schematicWorld, int baseX, int baseY, int baseZ) {
        this.minecraft = this.settings.minecraft;
        this.profiler = this.minecraft.J;
        this.tileEntities = new ArrayList();
        this.boundingBox = aqx.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.needsUpdate = true;
        this.glList = -1;
        this.schematic = schematicWorld;
        this.boundingBox.b((double)(baseX * 16), (double)(baseY * 16), (double)(baseZ * 16), (double)((baseX + 1) * 16), (double)((baseY + 1) * 16), (double)((baseZ + 1) * 16));
        this.centerPosition.x = (int)(((double)baseX + 0.5) * 16.0);
        this.centerPosition.y = (int)(((double)baseY + 0.5) * 16.0);
        this.centerPosition.z = (int)(((double)baseZ + 0.5) * 16.0);
        for (aqp tileEntity : this.schematic.getTileEntities()) {
            int x = tileEntity.l;
            int y = tileEntity.m;
            int z = tileEntity.n;
            if ((double)x < this.boundingBox.a || (double)x >= this.boundingBox.d || (double)z < this.boundingBox.c || (double)z >= this.boundingBox.f || (double)y < this.boundingBox.b || (double)y >= this.boundingBox.e) continue;
            this.tileEntities.add(tileEntity);
        }
        this.glList = GL11.glGenLists((int)3);
    }

    public void delete() {
        GL11.glDeleteLists((int)this.glList, (int)3);
    }

    public aqx getBoundingBox() {
        return this.boundingBox;
    }

    public static void setCanUpdate(boolean parCanUpdate) {
        canUpdate = parCanUpdate;
    }

    public static boolean getCanUpdate() {
        return canUpdate;
    }

    public void setDirty() {
        this.needsUpdate = true;
    }

    public boolean getDirty() {
        return this.needsUpdate;
    }

    public float distanceToPoint(Vector3f vector) {
        float x = vector.x - this.centerPosition.x;
        float y = vector.y - this.centerPosition.y;
        float z = vector.z - this.centerPosition.z;
        return x * x + y * y + z * z;
    }

    public void updateRenderer() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            RendererSchematicChunk.setCanUpdate(false);
            RenderHelper.createBuffers();
            for (int pass = 0; pass < 3; ++pass) {
                RenderHelper.initBuffers();
                int minX = (int)this.boundingBox.a;
                int maxX = Math.min((int)this.boundingBox.d, this.schematic.width());
                int minY = (int)this.boundingBox.b;
                int maxY = Math.min((int)this.boundingBox.e, this.schematic.height());
                int minZ = (int)this.boundingBox.c;
                int maxZ = Math.min((int)this.boundingBox.f, this.schematic.length());
                if (this.settings.renderingLayer >= 0) {
                    if (this.settings.renderingLayer >= minY && this.settings.renderingLayer < maxY) {
                        minY = this.settings.renderingLayer;
                        maxY = this.settings.renderingLayer + 1;
                    } else {
                        maxY = 0;
                        minY = 0;
                    }
                }
                GL11.glNewList((int)(this.glList + pass), (int)4864);
                this.renderBlocks(pass, minX, minY, minZ, maxX, maxY, maxZ);
                int quadCount = RenderHelper.getQuadCount();
                int lineCount = RenderHelper.getLineCount();
                if (quadCount > 0 || lineCount > 0) {
                    GL11.glDisable((int)3553);
                    GL11.glLineWidth((float)1.5f);
                    GL11.glEnableClientState((int)32884);
                    GL11.glEnableClientState((int)32886);
                    if (quadCount > 0) {
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getQuadVertexBuffer());
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getQuadColorBuffer());
                        GL11.glDrawArrays((int)7, (int)0, (int)quadCount);
                    }
                    if (lineCount > 0) {
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getLineVertexBuffer());
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getLineColorBuffer());
                        GL11.glDrawArrays((int)1, (int)0, (int)lineCount);
                    }
                    GL11.glDisableClientState((int)32886);
                    GL11.glDisableClientState((int)32884);
                    GL11.glEnable((int)3553);
                }
                GL11.glEndList();
            }
            RenderHelper.destroyBuffers();
        }
    }

    public void render(int renderPass) {
        if (!this.isInFrustrum) {
            return;
        }
        this.profiler.a("blocks");
        this.bindTexture();
        GL11.glCallList((int)(this.glList + renderPass));
        this.profiler.c("tileEntities");
        this.renderTileEntities(renderPass);
        this.profiler.b();
        this.minecraft.p.a();
    }

    public void renderBlocks(int renderPass, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        aaq mcWorld = this.settings.mcWorldCache;
        bgf renderBlocks = this.settings.renderBlocks;
        Vector3f zero = new Vector3f();
        Vector3f size = new Vector3f();
        int ambientOcclusion = this.minecraft.z.k;
        this.minecraft.z.k = 0;
        bgd.a.b();
        for (int y = minY; y < maxY; ++y) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    try {
                        int blockId = this.schematic.a(x, y, z);
                        apa block = apa.r[blockId];
                        int mcBlockId = mcWorld.a(x + (int)this.settings.offset.x, y + (int)this.settings.offset.y, z + (int)this.settings.offset.z);
                        int sides = 0;
                        if (block != null) {
                            if (block.a((aak)this.schematic, x, y - 1, z, 0)) {
                                sides |= 1;
                            }
                            if (block.a((aak)this.schematic, x, y + 1, z, 1)) {
                                sides |= 2;
                            }
                            if (block.a((aak)this.schematic, x, y, z - 1, 2)) {
                                sides |= 4;
                            }
                            if (block.a((aak)this.schematic, x, y, z + 1, 3)) {
                                sides |= 8;
                            }
                            if (block.a((aak)this.schematic, x - 1, y, z, 4)) {
                                sides |= 0x10;
                            }
                            if (block.a((aak)this.schematic, x + 1, y, z, 5)) {
                                sides |= 0x20;
                            }
                        }
                        if (mcBlockId != 0) {
                            if (!this.settings.highlight || renderPass != 2) continue;
                            if (blockId == 0 && this.settings.highlightAir) {
                                zero.set((float)x, (float)y, (float)z);
                                size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                                if (this.settings.drawQuads) {
                                    RenderHelper.drawCuboidSurface(zero, size, 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                }
                                if (!this.settings.drawLines) continue;
                                RenderHelper.drawCuboidOutline(zero, size, 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                continue;
                            }
                            if (blockId != mcBlockId) {
                                zero.set((float)x, (float)y, (float)z);
                                size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                                if (this.settings.drawQuads) {
                                    RenderHelper.drawCuboidSurface(zero, size, sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                }
                                if (!this.settings.drawLines) continue;
                                RenderHelper.drawCuboidOutline(zero, size, sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                continue;
                            }
                            if (this.schematic.h(x, y, z) == mcWorld.h(x + (int)this.settings.offset.x, y + (int)this.settings.offset.y, z + (int)this.settings.offset.z)) continue;
                            zero.set((float)x, (float)y, (float)z);
                            size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                            if (this.settings.drawQuads) {
                                RenderHelper.drawCuboidSurface(zero, size, sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            }
                            if (!this.settings.drawLines) continue;
                            RenderHelper.drawCuboidOutline(zero, size, sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            continue;
                        }
                        if (mcBlockId != 0 || blockId <= 0 || blockId >= 4096) continue;
                        if (this.settings.highlight && renderPass == 2) {
                            zero.set((float)x, (float)y, (float)z);
                            size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                            if (this.settings.drawQuads) {
                                RenderHelper.drawCuboidSurface(zero, size, sides, 0.0f, 0.75f, 1.0f, 0.25f);
                            }
                            if (this.settings.drawLines) {
                                RenderHelper.drawCuboidOutline(zero, size, sides, 0.0f, 0.75f, 1.0f, 0.25f);
                            }
                        }
                        if (block == null || !block.canRenderInPass(renderPass)) continue;
                        renderBlocks.b(block, x, y, z);
                        continue;
                    }
                    catch (Exception e) {
                        Settings.logger.c("Failed to render block!", (Throwable)e);
                    }
                }
            }
        }
        bgd.a.a();
        this.minecraft.z.k = ambientOcclusion;
    }

    public void renderTileEntities(int renderPass) {
        if (renderPass != 0) {
            return;
        }
        aaq mcWorld = this.settings.mcWorldCache;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.settings.alpha);
        try {
            for (aqp tileEntity : this.tileEntities) {
                bje tileEntitySpecialRenderer;
                int mcBlockId;
                int x = tileEntity.l;
                int y = tileEntity.m;
                int z = tileEntity.n;
                if (this.settings.renderingLayer >= 0 && y != this.settings.renderingLayer || (mcBlockId = mcWorld.a(x + (int)this.settings.offset.x, y + (int)this.settings.offset.y, z + (int)this.settings.offset.z)) != 0 || (tileEntitySpecialRenderer = bjd.a.b(tileEntity)) == null) continue;
                try {
                    tileEntitySpecialRenderer.a(tileEntity, (double)x, (double)y, (double)z, 0.0f);
                    bkn.a((int)bkn.b);
                    GL11.glDisable((int)3553);
                    bkn.a((int)bkn.a);
                }
                catch (Exception e) {
                    Settings.logger.c("Failed to render a tile entity!", (Throwable)e);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.settings.alpha);
            }
        }
        catch (Exception ex) {
            Settings.logger.c("Failed to render tile entities!", (Throwable)ex);
        }
    }

    private void bindTexture() {
        if (!this.settings.enableAlpha) {
            this.minecraft.p.b("/terrain.png");
            return;
        }
        bjt texturePackBase = this.minecraft.D.e();
        String texturePackFileName = texturePackBase.c() + "-" + (int)(this.settings.alpha * 255.0f);
        if (!texturePacks.containsKey(texturePackFileName)) {
            bio texture = this.minecraft.p.i.d();
            int width = texture.d();
            int height = texture.e();
            ByteBuffer buffer = texture.h();
            byte[] byteArray = new byte[width * height * 4];
            buffer.position(0);
            buffer.get(byteArray);
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int offset = (y * width + x) * 4;
                    int alpha = byteArray[offset + 3] & 0xFF;
                    int red = byteArray[offset + 0] & 0xFF;
                    int green = byteArray[offset + 1] & 0xFF;
                    int blue = byteArray[offset + 2] & 0xFF;
                    alpha = (int)((float)alpha * this.settings.alpha);
                    bufferedImage.setRGB(x, y, alpha << 24 | red << 16 | green << 8 | blue);
                }
            }
            texturePacks.put(texturePackFileName, this.minecraft.p.a(bufferedImage));
        }
        if (texturePacks.containsKey(texturePackFileName)) {
            GL11.glBindTexture((int)3553, (int)((Integer)texturePacks.get(texturePackFileName)));
        }
    }
}

