/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lunatrius.schematica.FileFilterSchematic;
import lunatrius.schematica.Settings;
import lunatrius.schematica.gui.GuiSchematicEntry;
import lunatrius.schematica.gui.GuiSchematicLoadSlot;
import org.lwjgl.Sys;

public class GuiSchematicLoad
extends axr {
    private static final FileFilterSchematic FILE_FILTER_FOLDER = new FileFilterSchematic(true);
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);
    private final Settings settings = Settings.instance();
    private final axr prevGuiScreen;
    private GuiSchematicLoadSlot guiSchematicLoadSlot;
    private final bp strTranslate = bp.a();
    private axy btnOpenDir = null;
    private axy btnDone = null;
    private final String strTitle = this.strTranslate.a("schematic.title");
    private final String strFolderInfo = this.strTranslate.a("schematic.folderInfo");
    protected File currentDirectory = Settings.schematicDirectory;
    protected final List schematicFiles = new ArrayList();

    public GuiSchematicLoad(axr guiScreen) {
        this.prevGuiScreen = guiScreen;
    }

    public void A_() {
        int id = 0;
        this.btnOpenDir = new axy(id++, this.h / 2 - 154, this.i - 36, this.strTranslate.a("schematic.openFolder"));
        this.k.add(this.btnOpenDir);
        this.btnDone = new axy(id++, this.h / 2 + 4, this.i - 36, this.strTranslate.a("schematic.done"));
        this.k.add(this.btnDone);
        this.guiSchematicLoadSlot = new GuiSchematicLoadSlot(this);
        this.reloadSchematics();
    }

    protected void a(awg guiButton) {
        if (guiButton.g) {
            if (guiButton.f == this.btnOpenDir.f) {
                boolean success = false;
                try {
                    Class<?> c = Class.forName("java.awt.Desktop");
                    Object m = c.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
                    c.getMethod("browse", URI.class).invoke(m, Settings.schematicDirectory.toURI());
                }
                catch (Throwable e) {
                    success = true;
                }
                if (success) {
                    Settings.logger.a("Opening via Sys class!");
                    Sys.openURL((String)("file://" + Settings.schematicDirectory.getAbsolutePath()));
                }
            } else if (guiButton.f == this.btnDone.f) {
                this.loadSchematic();
                this.g.a(this.prevGuiScreen);
            } else {
                this.guiSchematicLoadSlot.a(guiButton);
            }
        }
    }

    public void a(int x, int y, float partialTicks) {
        this.guiSchematicLoadSlot.a(x, y, partialTicks);
        this.a(this.m, this.strTitle, this.h / 2, 4, 0xFFFFFF);
        this.a(this.m, this.strFolderInfo, this.h / 2 - 78, this.i - 12, 0x808080);
        super.a(x, y, partialTicks);
    }

    public void b() {
    }

    protected void changeDirectory(String directory) {
        this.currentDirectory = new File(this.currentDirectory, directory);
        this.reloadSchematics();
    }

    protected void reloadSchematics() {
        String name = null;
        int itemID = -1;
        this.schematicFiles.clear();
        try {
            if (!this.currentDirectory.getCanonicalPath().equals(Settings.schematicDirectory.getCanonicalPath())) {
                this.schematicFiles.add(new GuiSchematicEntry("..", 327, 0, true));
            }
        }
        catch (IOException e) {
            Settings.logger.c("Failed to add GuiSchematicEntry!", (Throwable)e);
        }
        for (File file : this.currentDirectory.listFiles(FILE_FILTER_FOLDER)) {
            name = file.getName();
            itemID = file.listFiles().length == 0 ? 325 : 326;
            this.schematicFiles.add(new GuiSchematicEntry(name, itemID, 0, file.isDirectory()));
        }
        File[] files = this.currentDirectory.listFiles(FILE_FILTER_SCHEMATIC);
        if (files.length == 0) {
            this.schematicFiles.add(new GuiSchematicEntry(this.strTranslate.a("schematic.noschematic"), 3, 0, false));
        } else {
            for (File file : files) {
                name = file.getName();
                this.schematicFiles.add(new GuiSchematicEntry(name, this.readSchematicIcon(file.getAbsolutePath()), file.isDirectory()));
            }
        }
    }

    private wm readSchematicIcon(String filename) {
        try {
            FileInputStream stream = new FileInputStream(filename);
            bs tagCompound = cc.a((InputStream)stream);
            if (tagCompound != null && tagCompound.b("Icon")) {
                wm itemStack = Settings.defaultIcon.m();
                itemStack.c(tagCompound.l("Icon"));
                return itemStack;
            }
        }
        catch (Exception e) {
            Settings.logger.c("Failed to read schematic icon!", (Throwable)e);
        }
        return Settings.defaultIcon.m();
    }

    private void loadSchematic() {
        int selectedIndex = this.guiSchematicLoadSlot.selectedIndex;
        try {
            if (selectedIndex >= 0 && selectedIndex < this.schematicFiles.size()) {
                GuiSchematicEntry schematic = (GuiSchematicEntry)this.schematicFiles.get(selectedIndex);
                this.settings.loadSchematic(new File(this.currentDirectory, schematic.getName()).getCanonicalPath());
            }
        }
        catch (Exception e) {
            Settings.logger.c("Failed to load schematic!", (Throwable)e);
        }
        this.settings.moveHere();
    }
}

