/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Schematica;
import lunatrius.schematica.gui.GuiSchematicControl;
import lunatrius.schematica.gui.GuiSchematicLoad;
import lunatrius.schematica.gui.GuiSchematicSave;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import net.minecraft.client.Minecraft;
import org.lwjgl.util.vector.Vector3f;

public class Settings {
    private static final Settings instance = new Settings();
    public boolean enableAlpha = false;
    public float alpha = 1.0f;
    public boolean highlight = true;
    public boolean highlightAir = true;
    public float blockDelta = 0.005f;
    public int placeDelay = 1;
    public boolean placeInstantly = false;
    public boolean placeAdjacent = true;
    public boolean drawQuads = true;
    public boolean drawLines = true;
    public ava[] keyBindings = new ava[]{new ava("key.schematic.load", 181), new ava("key.schematic.save", 55), new ava("key.schematic.control", 74)};
    public static final String sbcDisablePrinter = "\u00a70\u00a72\u00a70\u00a70\u00a7e\u00a7f";
    public static final File schematicDirectory = new File(Minecraft.b(), "/schematics/");
    public static final File textureDirectory = new File(Minecraft.b(), "/resources/mod/schematica/");
    public static final ku logger = new kh(Schematica.class.getSimpleName(), "", new File(Minecraft.b(), "output-schematica.log").getAbsolutePath());
    public static final bhi renderItem = new bhi();
    public static final wm defaultIcon = new wm(2, 1, 0);
    public Minecraft minecraft = Minecraft.x();
    public aaq mcWorldCache = null;
    public SchematicWorld schematic = null;
    public Vector3f playerPosition = new Vector3f();
    public RendererSchematicChunk[][][] rendererSchematicChunk = null;
    public final List sortedRendererSchematicChunk = new ArrayList();
    public bgf renderBlocks = null;
    public Vector3f pointA = new Vector3f();
    public Vector3f pointB = new Vector3f();
    public Vector3f pointMin = new Vector3f();
    public Vector3f pointMax = new Vector3f();
    public int rotationRender = 0;
    public int orientation = 0;
    public Vector3f offset = new Vector3f();
    public boolean isRenderingSchematic = false;
    public int renderingLayer = -1;
    public boolean isRenderingGuide = false;
    public int chatLines = 0;
    public boolean isPrinterEnabled = true;
    public boolean isPrinting = false;
    public int[] increments = new int[]{1, 5, 15, 50, 250};

    private Settings() {
    }

    public static Settings instance() {
        return instance;
    }

    public void keyboardEvent(ava keybinding) {
        if (this.minecraft.s == null) {
            for (int i = 0; i < this.keyBindings.length; ++i) {
                if (keybinding != this.keyBindings[i]) continue;
                this.keyboardEvent(i);
                break;
            }
        }
    }

    public void keyboardEvent(int key) {
        switch (key) {
            case 0: {
                this.minecraft.a((axr)new GuiSchematicLoad(this.minecraft.s));
                break;
            }
            case 1: {
                this.minecraft.a((axr)new GuiSchematicSave(this.minecraft.s));
                break;
            }
            case 2: {
                this.minecraft.a((axr)new GuiSchematicControl(this.minecraft.s));
            }
        }
    }

    public void createRendererSchematicChunk() {
        int width = (this.schematic.width() - 1) / 16 + 1;
        int height = (this.schematic.height() - 1) / 16 + 1;
        int length = (this.schematic.length() - 1) / 16 + 1;
        this.rendererSchematicChunk = new RendererSchematicChunk[width][height][length];
        while (this.sortedRendererSchematicChunk.size() > 0) {
            ((RendererSchematicChunk)this.sortedRendererSchematicChunk.remove(0)).delete();
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    RendererSchematicChunk rendererSchematicChunk = new RendererSchematicChunk(this.schematic, x, y, z);
                    this.rendererSchematicChunk[x][y][z] = rendererSchematicChunk;
                    this.sortedRendererSchematicChunk.add(rendererSchematicChunk);
                }
            }
        }
    }

    public boolean loadSchematic(String filename) {
        try {
            FileInputStream stream = new FileInputStream(filename);
            bs tagCompound = cc.a((InputStream)stream);
            if (tagCompound != null) {
                this.schematic = new SchematicWorld();
                this.schematic.readFromNBT(tagCompound);
                logger.a(String.format("Loaded %s [w:%d,h:%d,l:%d]", filename, this.schematic.width(), this.schematic.height(), this.schematic.length()));
                this.renderBlocks = new bgf((aak)this.schematic);
                this.createRendererSchematicChunk();
                this.isRenderingSchematic = true;
            }
        }
        catch (Exception e) {
            logger.c("Failed to load schematic!", (Throwable)e);
            this.schematic = null;
            this.renderBlocks = null;
            this.rendererSchematicChunk = null;
            this.isRenderingSchematic = false;
            return false;
        }
        return true;
    }

    public boolean saveSchematic(File directory, String filename, Vector3f from, Vector3f to) {
        try {
            bs tagCompound = new bs("Schematic");
            int minX = (int)Math.min(from.x, to.x);
            int maxX = (int)Math.max(from.x, to.x);
            int minY = (int)Math.min(from.y, to.y);
            int maxY = (int)Math.max(from.y, to.y);
            int minZ = (int)Math.min(from.z, to.z);
            int maxZ = (int)Math.max(from.z, to.z);
            short width = (short)(Math.abs(maxX - minX) + 1);
            short height = (short)(Math.abs(maxY - minY) + 1);
            short length = (short)(Math.abs(maxZ - minZ) + 1);
            int[][][] blocks = new int[width][height][length];
            int[][][] metadata = new int[width][height][length];
            ArrayList<aqp> tileEntities = new ArrayList<aqp>();
            aqp tileEntity = null;
            bs tileEntityNBT = null;
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        blocks[x - minX][y - minY][z - minZ] = this.minecraft.e.a(x, y, z);
                        metadata[x - minX][y - minY][z - minZ] = this.minecraft.e.h(x, y, z);
                        tileEntity = this.minecraft.e.r(x, y, z);
                        if (tileEntity == null) continue;
                        tileEntityNBT = new bs();
                        tileEntity.b(tileEntityNBT);
                        tileEntity = aqp.c((bs)tileEntityNBT);
                        tileEntity.l -= minX;
                        tileEntity.m -= minY;
                        tileEntity.n -= minZ;
                        tileEntities.add(tileEntity);
                    }
                }
            }
            String icon = Integer.toString(Settings.defaultIcon.m().c);
            try {
                String[] parts = filename.split(";");
                if (parts.length == 2) {
                    icon = parts[0];
                    filename = parts[1];
                }
            }
            catch (Exception e) {
                logger.c("Failed to parse icon data!", (Throwable)e);
            }
            SchematicWorld schematicOut = new SchematicWorld(icon, blocks, metadata, tileEntities, width, height, length);
            schematicOut.writeToNBT(tagCompound);
            FileOutputStream stream = new FileOutputStream(new File(directory, filename));
            cc.a((bs)tagCompound, (OutputStream)stream);
        }
        catch (Exception e) {
            logger.c("Failed to save schematic!", (Throwable)e);
            return false;
        }
        return true;
    }

    public float getTranslationX() {
        return this.playerPosition.x - this.offset.x;
    }

    public float getTranslationY() {
        return this.playerPosition.y - this.offset.y;
    }

    public float getTranslationZ() {
        return this.playerPosition.z - this.offset.z;
    }

    public void refreshSchematic() {
        for (RendererSchematicChunk renderer : this.sortedRendererSchematicChunk) {
            renderer.setDirty();
        }
    }

    public void updatePoints() {
        this.pointMin.x = Math.min(this.pointA.x, this.pointB.x);
        this.pointMin.y = Math.min(this.pointA.y, this.pointB.y);
        this.pointMin.z = Math.min(this.pointA.z, this.pointB.z);
        this.pointMax.x = Math.max(this.pointA.x, this.pointB.x);
        this.pointMax.y = Math.max(this.pointA.y, this.pointB.y);
        this.pointMax.z = Math.max(this.pointA.z, this.pointB.z);
    }

    public void moveHere(Vector3f point) {
        point.x = (int)Math.floor(this.playerPosition.x);
        point.y = (int)Math.floor(this.playerPosition.y - 1.0f);
        point.z = (int)Math.floor(this.playerPosition.z);
        switch (this.rotationRender) {
            case 0: {
                point.x -= 1.0f;
                point.z += 1.0f;
                break;
            }
            case 1: {
                point.x -= 1.0f;
                point.z -= 1.0f;
                break;
            }
            case 2: {
                point.x += 1.0f;
                point.z -= 1.0f;
                break;
            }
            case 3: {
                point.x += 1.0f;
                point.z += 1.0f;
            }
        }
    }

    public void moveHere() {
        this.offset.x = (int)Math.floor(this.playerPosition.x);
        this.offset.y = (int)Math.floor(this.playerPosition.y) - 1;
        this.offset.z = (int)Math.floor(this.playerPosition.z);
        if (this.schematic != null) {
            switch (this.rotationRender) {
                case 0: {
                    this.offset.x -= (float)this.schematic.width();
                    this.offset.z += 1.0f;
                    break;
                }
                case 1: {
                    this.offset.x -= (float)this.schematic.width();
                    this.offset.z -= (float)this.schematic.length();
                    break;
                }
                case 2: {
                    this.offset.x += 1.0f;
                    this.offset.z -= (float)this.schematic.length();
                    break;
                }
                case 3: {
                    this.offset.x += 1.0f;
                    this.offset.z += 1.0f;
                }
            }
            this.reloadChunkCache();
        }
    }

    public void toggleRendering() {
        this.isRenderingSchematic = !this.isRenderingSchematic && this.schematic != null;
    }

    public void reloadChunkCache() {
        if (this.schematic != null) {
            this.mcWorldCache = new aaq((aab)this.minecraft.e, (int)this.offset.x - 1, (int)this.offset.y - 1, (int)this.offset.z - 1, (int)this.offset.x + this.schematic.width() + 1, (int)this.offset.y + this.schematic.height() + 1, (int)this.offset.z + this.schematic.length() + 1, 0);
            this.refreshSchematic();
        }
    }

    public void flipWorld() {
        if (this.schematic != null) {
            this.schematic.flip();
            this.createRendererSchematicChunk();
        }
    }

    public void rotateWorld() {
        if (this.schematic != null) {
            this.schematic.rotate();
            this.createRendererSchematicChunk();
        }
    }
}

