/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lunatrius.schematica.BlockInfo;
import lunatrius.schematica.ChatEventHandler;
import lunatrius.schematica.FileFilterConfiguration;
import lunatrius.schematica.KeyBindingHandler;
import lunatrius.schematica.SchematicPrinter;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import lunatrius.schematica.Ticker;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import lunatrius.schematica.renderer.RendererSchematicGlobal;
import lunatrius.schematica.util.Config;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Schematica")
public class Schematica {
    private static final FileFilterConfiguration FILE_FILTER_CONFIGURATION = new FileFilterConfiguration();
    private static final String DIR_ASSETS = "lunatrius/schematica/assets/";
    private final Settings settings = Settings.instance();
    private final la profiler;
    private final SchematicPrinter printer;
    private int ticks;
    @Mod.Instance(value="Schematica")
    public static Schematica instance;
    private Field sortedWorldRenderers;
    private File configurationFolder;

    public Schematica() {
        this.profiler = this.settings.minecraft.J;
        this.printer = new SchematicPrinter();
        this.ticks = -1;
        this.sortedWorldRenderers = null;
        this.configurationFolder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        File suggestedConfigurationFile = event.getSuggestedConfigurationFile();
        Configuration config = new Configuration(suggestedConfigurationFile);
        this.configurationFolder = suggestedConfigurationFile.getParentFile();
        config.load();
        this.settings.enableAlpha = Config.getBoolean(config, "general", "alphaEnabled", this.settings.enableAlpha, "Enable transparent textures.");
        this.settings.alpha = (float)Config.getInt(config, "general", "alpha", (int)(this.settings.alpha * 255.0f), 0, 255, "Alpha value used when rendering the schematic.") / 255.0f;
        this.settings.highlight = Config.getBoolean(config, "general", "highlight", this.settings.highlight, "Highlight invalid placed blocks and to be placed blocks.");
        this.settings.highlightAir = Config.getBoolean(config, "general", "highlightAir", this.settings.highlightAir, "Highlight invalid placed blocks (where there should be no block).");
        this.settings.blockDelta = (float)Config.getDouble(config, "general", "blockDelta", this.settings.blockDelta, 0.0, 0.5, "Delta value used for highlighting (if you're having issue with overlapping textures try setting this value higher).");
        this.settings.placeDelay = Config.getInt(config, "general", "placeDelay", this.settings.placeDelay, 0, 20, "Delay in ticks between placement attempts.");
        this.settings.placeInstantly = Config.getBoolean(config, "general", "placeInstantly", this.settings.placeInstantly, "Place all blocks that can be placed in one tick.");
        this.settings.placeAdjacent = Config.getBoolean(config, "general", "placeAdjacent", this.settings.placeAdjacent, "Place blocks only if there is an adjacent block next to it.");
        this.settings.drawQuads = Config.getBoolean(config, "general", "drawQuads", this.settings.drawQuads, "Draw surface areas.");
        this.settings.drawLines = Config.getBoolean(config, "general", "drawLines", this.settings.drawLines, "Draw outlines.");
        config.save();
        try {
            String langDir = "lunatrius/schematica/assets/lang/";
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream stream = classLoader.getResourceAsStream(langDir + "lang.txt");
            BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            try {
                String lang = "";
                while ((lang = input.readLine()) != null) {
                    if (lang.length() <= 0) continue;
                    Settings.logger.a("Loading language file: " + lang);
                    LanguageRegistry.instance().loadLocalization(classLoader.getResource(langDir + lang + ".xml"), lang, true);
                }
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            Settings.logger.c("Could not load language files - corrupted installation detected!", (Throwable)e);
            throw new RuntimeException(e);
        }
        List blockListIgnoreID = SchematicWorld.blockListIgnoreID;
        blockListIgnoreID.add(apa.ae.cz);
        blockListIgnoreID.add(apa.ag.cz);
        blockListIgnoreID.add(apa.bi.cz);
        blockListIgnoreID.add(apa.bL.cz);
        List blockListIgnoreMetadata = SchematicWorld.blockListIgnoreMetadata;
        blockListIgnoreMetadata.add(apa.E.cz);
        blockListIgnoreMetadata.add(apa.F.cz);
        blockListIgnoreMetadata.add(apa.G.cz);
        blockListIgnoreMetadata.add(apa.H.cz);
        blockListIgnoreMetadata.add(apa.T.cz);
        blockListIgnoreMetadata.add(apa.W.cz);
        blockListIgnoreMetadata.add(apa.X.cz);
        blockListIgnoreMetadata.add(apa.Y.cz);
        blockListIgnoreMetadata.add(apa.Z.cz);
        blockListIgnoreMetadata.add(apa.ad.cz);
        blockListIgnoreMetadata.add(apa.ao.cz);
        blockListIgnoreMetadata.add(apa.au.cz);
        blockListIgnoreMetadata.add(apa.ax.cz);
        blockListIgnoreMetadata.add(apa.ay.cz);
        blockListIgnoreMetadata.add(apa.az.cz);
        blockListIgnoreMetadata.add(apa.aD.cz);
        blockListIgnoreMetadata.add(apa.aE.cz);
        blockListIgnoreMetadata.add(apa.aF.cz);
        blockListIgnoreMetadata.add(apa.aG.cz);
        blockListIgnoreMetadata.add(apa.aH.cz);
        blockListIgnoreMetadata.add(apa.aI.cz);
        blockListIgnoreMetadata.add(apa.aJ.cz);
        blockListIgnoreMetadata.add(apa.aK.cz);
        blockListIgnoreMetadata.add(apa.aL.cz);
        blockListIgnoreMetadata.add(apa.aM.cz);
        blockListIgnoreMetadata.add(apa.aN.cz);
        blockListIgnoreMetadata.add(apa.aO.cz);
        blockListIgnoreMetadata.add(apa.aP.cz);
        blockListIgnoreMetadata.add(apa.aQ.cz);
        blockListIgnoreMetadata.add(apa.aT.cz);
        blockListIgnoreMetadata.add(apa.aU.cz);
        blockListIgnoreMetadata.add(apa.aV.cz);
        blockListIgnoreMetadata.add(apa.be.cz);
        blockListIgnoreMetadata.add(apa.bi.cz);
        blockListIgnoreMetadata.add(apa.bj.cz);
        blockListIgnoreMetadata.add(apa.bk.cz);
        blockListIgnoreMetadata.add(apa.bl.cz);
        blockListIgnoreMetadata.add(apa.bm.cz);
        blockListIgnoreMetadata.add(apa.bo.cz);
        blockListIgnoreMetadata.add(apa.by.cz);
        blockListIgnoreMetadata.add(apa.bz.cz);
        blockListIgnoreMetadata.add(apa.bA.cz);
        blockListIgnoreMetadata.add(apa.bB.cz);
        blockListIgnoreMetadata.add(apa.bD.cz);
        blockListIgnoreMetadata.add(apa.bG.cz);
        blockListIgnoreMetadata.add(apa.bH.cz);
        blockListIgnoreMetadata.add(apa.bM.cz);
        blockListIgnoreMetadata.add(apa.bP.cz);
        blockListIgnoreMetadata.add(apa.bQ.cz);
        blockListIgnoreMetadata.add(apa.bS.cz);
        blockListIgnoreMetadata.add(apa.bU.cz);
        blockListIgnoreMetadata.add(apa.bW.cz);
        blockListIgnoreMetadata.add(apa.bX.cz);
        blockListIgnoreMetadata.add(apa.bY.cz);
        blockListIgnoreMetadata.add(apa.ca.cz);
        blockListIgnoreMetadata.add(apa.cb.cz);
        blockListIgnoreMetadata.add(apa.cc.cz);
        blockListIgnoreMetadata.add(apa.cg.cz);
        blockListIgnoreMetadata.add(apa.ch.cz);
        blockListIgnoreMetadata.add(apa.ci.cz);
        blockListIgnoreMetadata.add(apa.cj.cz);
        blockListIgnoreMetadata.add(apa.cl.cz);
        Map blockListMapping = SchematicWorld.blockListMapping;
        blockListMapping.put(apa.E.cz, wk.ay.cp);
        blockListMapping.put(apa.F.cz, wk.ay.cp);
        blockListMapping.put(apa.G.cz, wk.az.cp);
        blockListMapping.put(apa.H.cz, wk.az.cp);
        blockListMapping.put(apa.W.cz, wk.bb.cp);
        blockListMapping.put(apa.az.cz, wk.aD.cp);
        blockListMapping.put(apa.aD.cz, wk.T.cp);
        blockListMapping.put(apa.aG.cz, apa.aF.cz);
        blockListMapping.put(apa.aH.cz, wk.av.cp);
        blockListMapping.put(apa.aI.cz, wk.aw.cp);
        blockListMapping.put(apa.aP.cz, wk.aC.cp);
        blockListMapping.put(apa.aM.cz, wk.av.cp);
        blockListMapping.put(apa.aT.cz, apa.aU.cz);
        blockListMapping.put(apa.bl.cz, wk.bc.cp);
        blockListMapping.put(apa.bm.cz, wk.bc.cp);
        blockListMapping.put(apa.bw.cz, wk.bh.cp);
        blockListMapping.put(apa.bx.cz, wk.bi.cp);
        blockListMapping.put(apa.bH.cz, wk.bs.cp);
        blockListMapping.put(apa.bJ.cz, wk.bz.cp);
        blockListMapping.put(apa.bK.cz, wk.bA.cp);
        blockListMapping.put(apa.bQ.cz, apa.bP.cz);
        blockListMapping.put(apa.bT.cz, wk.aX.cp);
        blockListMapping.put(apa.bY.cz, wk.L.cp);
        blockListMapping.put(apa.cg.cz, wk.bK.cp);
        blockListMapping.put(apa.ch.cz, wk.bL.cp);
        blockListMapping.put(apa.ci.cz, wk.bM.cp);
        blockListMapping.put(apa.ck.cz, wk.bR.cp);
        if (!Settings.schematicDirectory.exists() && !Settings.schematicDirectory.mkdirs()) {
            Settings.logger.a("Could not create schematic directory!");
        }
        if (!Settings.textureDirectory.exists() && !Settings.textureDirectory.mkdirs()) {
            Settings.logger.a("Could not create texture directory!");
        }
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new RendererSchematicGlobal());
            MinecraftForge.EVENT_BUS.register((Object)new ChatEventHandler());
            KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingHandler(this.settings.keyBindings, new boolean[this.settings.keyBindings.length]));
            TickRegistry.registerTickHandler((ITickHandler)new Ticker(EnumSet.of(TickType.CLIENT)), (Side)Side.CLIENT);
            this.sortedWorldRenderers = ReflectionHelper.findField(bfy.class, (String[])new String[]{"k", "field_72768_k", "sortedWorldRenderers"});
        }
        catch (Exception e) {
            Settings.logger.c("Could not initialize the mod!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        File[] configurationFiles;
        String[] files = new String[]{"aliasVanilla", "flipVanilla", "rotationVanilla"};
        String mappingDir = "lunatrius/schematica/assets/mapping/";
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (String filename : files) {
            this.loadConfigurationFile(classLoader.getResource(mappingDir + filename + ".properties"), filename + ".properties");
        }
        for (File configurationFile : configurationFiles = this.configurationFolder.listFiles(FILE_FILTER_CONFIGURATION)) {
            try {
                this.loadConfigurationFile(configurationFile.toURI().toURL(), configurationFile.getName());
            }
            catch (MalformedURLException e) {
                Settings.logger.c("Could not load properties file.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigurationFile(URL configurationFile, String configurationFilename) {
        if (configurationFile == null) {
            Settings.logger.a("Skipping " + configurationFilename + "...");
            return;
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        Settings.logger.a("Reading " + configurationFilename + "...");
        try {
            inputStream = configurationFile.openStream();
            properties.load(inputStream);
        }
        catch (IOException e) {
            Settings.logger.c("Could not load properties file.", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Settings.logger.c("Could not close properties file.", (Throwable)e);
            }
        }
        String filename = configurationFilename.toLowerCase();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (filename.startsWith("alias")) {
                if (BlockInfo.addMappingAlias(key, value)) continue;
                Settings.logger.b("Failed alias: " + key + " => " + value);
                continue;
            }
            if (filename.startsWith("flip")) {
                if (BlockInfo.addMappingFlip(key, value)) continue;
                Settings.logger.b("Failed flip: " + key + " => " + value);
                continue;
            }
            if (!filename.startsWith("rotation") || BlockInfo.addMappingRotation(key, value)) continue;
            Settings.logger.b("Failed rotation: " + key + " => " + value);
        }
    }

    public void keyboardEvent(ava keyBinding, boolean down) {
        if (down) {
            this.settings.keyboardEvent(keyBinding);
        }
    }

    public boolean onTick(TickType tick, boolean start) {
        if (start) {
            return true;
        }
        this.profiler.a("schematica");
        if (tick == TickType.CLIENT && this.settings.minecraft.g != null && this.settings.isRenderingSchematic && this.settings.schematic != null) {
            this.profiler.a("printer");
            if (this.settings.isPrinterEnabled && this.settings.isPrinting && this.ticks-- < 0) {
                this.ticks = this.settings.placeDelay;
                this.printer.print();
            }
            this.profiler.c("checkDirty");
            this.checkDirty();
            this.profiler.c("canUpdate");
            RendererSchematicChunk.setCanUpdate(true);
            this.profiler.b();
        } else if (tick == TickType.CLIENT && this.settings.minecraft.g == null) {
            this.settings.chatLines = 0;
            this.settings.isPrinterEnabled = true;
            this.settings.isRenderingSchematic = false;
            this.settings.isRenderingGuide = false;
            this.settings.schematic = null;
            this.settings.mcWorldCache = null;
        }
        this.profiler.b();
        return true;
    }

    private void checkDirty() {
        if (this.sortedWorldRenderers != null) {
            try {
                bfm[] renderers = (bfm[])this.sortedWorldRenderers.get(this.settings.minecraft.f);
                if (renderers != null) {
                    int count = 0;
                    for (bfm worldRenderer : renderers) {
                        if (!worldRenderer.q || count++ >= 125) continue;
                        aqx worldRendererBoundingBox = worldRenderer.r.c((double)(-this.settings.offset.x), (double)(-this.settings.offset.y), (double)(-this.settings.offset.z));
                        for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                            if (renderer.getDirty() || !renderer.getBoundingBox().a(worldRendererBoundingBox)) continue;
                            renderer.setDirty();
                        }
                    }
                }
            }
            catch (Exception e) {
                Settings.logger.c("Dirty check failed!", (Throwable)e);
            }
        }
    }
}

