/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import java.util.HashMap;
import java.util.Map;
import lunatrius.schematica.Settings;

public class BlockInfo {
    private static final Map ALIAS = new HashMap();
    private static final Map FLIP = new HashMap();
    private static final Map ROTATION = new HashMap();

    public static boolean addMappingAlias(String key, String value) {
        String k = key;
        int v = BlockInfo.parseNumber(value);
        if (v > 0) {
            ALIAS.put(k, v);
            return true;
        }
        return false;
    }

    public static boolean addMappingRotation(String key, String value) {
        return BlockInfo.addMapping(key, value, ROTATION);
    }

    public static boolean addMappingFlip(String key, String value) {
        return BlockInfo.addMapping(key, value, FLIP);
    }

    private static boolean addMapping(String key, String value, Map map) {
        int k = BlockInfo.parseInfo(key);
        int v = BlockInfo.parseInfo(value);
        if (k > 0 && v > 0) {
            map.put(k, v);
            return true;
        }
        return false;
    }

    private static int parseInfo(String str) {
        String[] parts = str.split("-");
        int blockId = BlockInfo.getBlockId(parts[0]) << 8;
        if (blockId > 0) {
            if (parts.length == 1) {
                return blockId;
            }
            if (parts.length == 2) {
                return blockId | BlockInfo.parseNumber(parts[1]) & 0xF;
            }
        }
        return 0;
    }

    private static int getBlockId(String str) {
        if (ALIAS.containsKey(str)) {
            return (Integer)ALIAS.get(str);
        }
        return BlockInfo.parseNumber(str);
    }

    private static int parseNumber(String str) {
        try {
            return Integer.valueOf(str, 10);
        }
        catch (NumberFormatException e) {
            Settings.logger.c("Could not parse the given number!", (Throwable)e);
            return 0;
        }
    }

    public static int getTransformedMetadataRotation(int blockId, int metadata) {
        return BlockInfo.getTransformedMetadata(blockId, metadata, ROTATION);
    }

    public static int getTransformedMetadataFlip(int blockId, int metadata) {
        return BlockInfo.getTransformedMetadata(blockId, metadata, FLIP);
    }

    private static int getTransformedMetadata(int blockId, int metadata, Map map) {
        int key = blockId << 8 | metadata;
        if (map.containsKey(key)) {
            return (Integer)map.get(key) & 0xF;
        }
        return metadata;
    }
}

