/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.TileEntity;
import net.minecraft.src.Vec3;
import net.minecraft.src.World;
import net.minecraft.src.WorldClient;
import net.minecraftforge.common.IShearable;

public class RayTracing {
    private static RayTracing _instance;
    private MovingObjectPosition target = null;

    private RayTracing() {
        _instance = this;
    }

    public static RayTracing instance() {
        return _instance == null ? new RayTracing() : _instance;
    }

    public void fire() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == EnumMovingObjectType.ENTITY && RayTracing.shouldShowEntity(mc.field_71476_x.field_72308_g)) {
            this.target = mc.field_71476_x;
            return;
        }
        EntityLiving viewpoint = mc.field_71451_h;
        if (viewpoint == null) {
            return;
        }
        this.target = this.rayTrace(viewpoint, mc.field_71442_b.func_78757_d(), 0.0f);
    }

    public void clear() {
        this.target = null;
    }

    private static boolean shouldShowEntity(Entity entity) {
        if (entity instanceof EntityPlayer) {
            boolean setting = PluginConfig.instance().get("general.invisibleplayers");
            return setting || !entity.func_82150_aj();
        }
        return true;
    }

    public MovingObjectPosition getTarget() {
        return this.target;
    }

    public ItemStack getTargetStack() {
        return this.getIdentifierStack();
    }

    public Entity getTargetEntity() {
        return this.target.field_72313_a == EnumMovingObjectType.ENTITY ? this.getIdentifierEntity() : null;
    }

    public MovingObjectPosition rayTrace(EntityLiving entity, double par1, float par3) {
        Vec3 vec3 = entity.func_70666_h(par3);
        Vec3 vec31 = entity.func_70676_i(par3);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * par1, vec31.field_72448_b * par1, vec31.field_72449_c * par1);
        if (PluginConfig.instance().get("general", "waila.cfg.liquid", false)) {
            return entity.field_70170_p.func_72901_a(vec3, vec32, true);
        }
        return entity.field_70170_p.func_72901_a(vec3, vec32, false);
    }

    public ItemStack getIdentifierStack() {
        List<ItemStack> items = this.getIdentifierItems();
        if (items.isEmpty()) {
            return null;
        }
        Collections.sort(items, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack0, ItemStack stack1) {
                return stack1.func_77960_j() - stack0.func_77960_j();
            }
        });
        return items.get(0);
    }

    public Entity getIdentifierEntity() {
        ArrayList<Entity> ents = new ArrayList<Entity>();
        if (this.target == null) {
            return null;
        }
        if (WailaRegistrar.instance().hasOverrideEntityProviders(this.target.field_72308_g)) {
            for (List<IEntityProvider> listProviders : WailaRegistrar.instance().getOverrideEntityProviders(this.target.field_72308_g).values()) {
                for (IEntityProvider provider : listProviders) {
                    ents.add(provider.getOverride(DataAccessorCommon.INSTANCE, PluginConfig.instance()));
                }
            }
        }
        return !ents.isEmpty() ? (Entity)ents.get(0) : this.target.field_72308_g;
    }

    public List<ItemStack> getIdentifierItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.target == null) {
            return items;
        }
        switch (this.target.field_72313_a) {
            case ENTITY: {
                if (this.target.field_72308_g == null || !WailaRegistrar.instance().hasStackEntityProviders(this.target.field_72308_g)) break;
                for (List<IEntityProvider> providersList : WailaRegistrar.instance().getStackEntityProviders(this.target.field_72308_g).values()) {
                    for (IEntityProvider provider : providersList) {
                        ItemStack providerStack = provider.getDisplayItem(DataAccessorCommon.INSTANCE, PluginConfig.instance());
                        if (providerStack == null) continue;
                        if (providerStack.func_77973_b() == null) {
                            return new ArrayList<ItemStack>();
                        }
                        items.add(providerStack);
                    }
                }
                break;
            }
            case TILE: {
                IShearable shearable;
                ItemStack providerStack;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                int x = this.target.field_72311_b;
                int y = this.target.field_72312_c;
                int z = this.target.field_72309_d;
                int blockID = world.func_72798_a(x, y, z);
                Block mouseoverBlock = Block.field_71973_m[blockID];
                TileEntity tileEntity = world.func_72796_p(x, y, z);
                if (mouseoverBlock == null) {
                    return items;
                }
                if (WailaRegistrar.instance().hasStackProviders(mouseoverBlock)) {
                    for (List<IDataProvider> providersList : WailaRegistrar.instance().getStackProviders(mouseoverBlock).values()) {
                        for (IDataProvider provider : providersList) {
                            providerStack = provider.getStack(DataAccessorCommon.INSTANCE, PluginConfig.instance());
                            if (providerStack == null) continue;
                            if (providerStack.func_77973_b() == null) {
                                return new ArrayList<ItemStack>();
                            }
                            items.add(providerStack);
                        }
                    }
                }
                if (tileEntity != null && WailaRegistrar.instance().hasStackProviders(tileEntity)) {
                    for (List<IDataProvider> providersList : WailaRegistrar.instance().getStackProviders(tileEntity).values()) {
                        for (IDataProvider provider : providersList) {
                            providerStack = provider.getStack(DataAccessorCommon.INSTANCE, PluginConfig.instance());
                            if (providerStack == null) continue;
                            if (providerStack.func_77973_b() == null) {
                                return new ArrayList<ItemStack>();
                            }
                            items.add(providerStack);
                        }
                    }
                }
                if (!items.isEmpty()) {
                    return items;
                }
                if (world.func_72796_p(x, y, z) == null) {
                    try {
                        ItemStack block = new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z));
                        if (block.func_77973_b() != null) {
                            items.add(block);
                        }
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                }
                if (!items.isEmpty()) {
                    return items;
                }
                try {
                    ItemStack pick = mouseoverBlock.getPickBlock(this.target, (World)world, x, y, z);
                    if (pick != null) {
                        items.add(pick);
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                if (!items.isEmpty()) {
                    return items;
                }
                if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ItemStack((Item)Item.field_77745_be), (World)world, x, y, z)) {
                    items.addAll(shearable.onSheared(new ItemStack((Item)Item.field_77745_be), (World)world, x, y, z, 0));
                }
                if (!items.isEmpty()) break;
                items.add(0, new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z)));
            }
        }
        return items;
    }
}

