/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mcp.mobius.waila.network.IWailaPacket;
import mcp.mobius.waila.network.Packet0x00ServerPing;
import mcp.mobius.waila.network.Packet0x01TileRequest;
import mcp.mobius.waila.network.Packet0x02EntRequest;
import mcp.mobius.waila.network.Packet0x03NBTData;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.INetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet250CustomPayload;

public class WailaPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        try {
            if (packet.field_73630_a.equals("BlockHelper")) {
                DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
                byte header = WailaPacketHandler.getHeader(inputStream);
                IWailaPacket castedPacket = WailaPacketHandler.getWailaPacket(header);
                if (castedPacket != null) {
                    castedPacket.decode(inputStream);
                    if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                        castedPacket.handleClient();
                    } else {
                        castedPacket.handleServer(player);
                    }
                }
                inputStream.close();
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    public static byte getHeader(DataInputStream inputStream) {
        try {
            return inputStream.readByte();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static IWailaPacket getWailaPacket(byte header) {
        if (header == 0) {
            return new Packet0x00ServerPing();
        }
        if (header == 1) {
            return new Packet0x01TileRequest();
        }
        if (header == 2) {
            return new Packet0x02EntRequest();
        }
        if (header == 3) {
            return new Packet0x03NBTData();
        }
        return null;
    }

    public static byte getPacketId(IWailaPacket packet) {
        if (packet instanceof Packet0x00ServerPing) {
            return 0;
        }
        if (packet instanceof Packet0x01TileRequest) {
            return 1;
        }
        if (packet instanceof Packet0x02EntRequest) {
            return 2;
        }
        if (packet instanceof Packet0x03NBTData) {
            return 3;
        }
        return -1;
    }

    public static Packet250CustomPayload wrapMLPacket(IWailaPacket packet) {
        Packet250CustomPayload mlPacket = new Packet250CustomPayload();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeByte(WailaPacketHandler.getPacketId(packet));
            packet.encode(outputStream);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, packet.getClass(), null);
        }
        mlPacket.field_73630_a = "BlockHelper";
        mlPacket.field_73629_c = bos.toByteArray();
        mlPacket.field_73628_b = bos.size();
        return mlPacket;
    }

    public static void sendPacketToPlayer(IWailaPacket packet, Player player) {
        PacketDispatcher.sendPacketToPlayer((Packet)WailaPacketHandler.wrapMLPacket(packet), (Player)player);
    }

    public static void sendPacketToServer(IWailaPacket packet) {
        PacketDispatcher.sendPacketToServer((Packet)WailaPacketHandler.wrapMLPacket(packet));
    }
}

