/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.utils.NBTUtil;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.Vec3;
import net.minecraft.src.World;
import net.minecraftforge.common.ForgeDirection;

public class DataAccessorCommon
implements ICommonAccessor,
IDataAccessor,
IEntityAccessor {
    public World world;
    public EntityPlayer player;
    public MovingObjectPosition mop;
    public Vec3 renderingvec = null;
    public Block block;
    public int blockID;
    public int metadata;
    public TileEntity tileEntity;
    public Entity entity;
    public NBTTagCompound remoteNbt = new NBTTagCompound();
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public ItemStack stack;
    public static final DataAccessorCommon INSTANCE = new DataAccessorCommon();

    public void set(World _world, EntityPlayer _player, MovingObjectPosition _mop) {
        this.set(_world, _player, _mop, null, 0.0);
    }

    public void set(World _world, EntityPlayer _player, MovingObjectPosition _mop, EntityLiving viewEntity, double partialTicks) {
        this.world = _world;
        this.player = _player;
        this.mop = _mop;
        if (this.mop == null) {
            this.renderingvec = null;
            this.block = null;
            this.blockID = 0;
            this.metadata = 0;
            this.tileEntity = null;
            this.entity = null;
            this.remoteNbt = new NBTTagCompound();
            this.timeLastUpdate = System.currentTimeMillis();
            this.partialFrame = 0.0;
            this.stack = null;
        } else {
            if (this.mop.field_72313_a == EnumMovingObjectType.TILE) {
                this.blockID = this.world.func_72798_a(this.mop.field_72311_b, this.mop.field_72312_c, this.mop.field_72309_d);
                this.metadata = this.world.func_72805_g(this.mop.field_72311_b, this.mop.field_72312_c, this.mop.field_72309_d);
                this.block = Block.field_71973_m[this.blockID];
                this.tileEntity = this.world.func_72796_p(this.mop.field_72311_b, this.mop.field_72312_c, this.mop.field_72309_d);
                this.entity = null;
                try {
                    this.stack = new ItemStack(this.block, 1, this.metadata);
                }
                catch (Throwable ignored) {}
            } else if (this.mop.field_72313_a == EnumMovingObjectType.ENTITY) {
                this.block = null;
                this.metadata = -1;
                this.tileEntity = null;
                this.stack = null;
                this.entity = this.mop.field_72308_g;
            }
            if (viewEntity != null) {
                double px = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTicks;
                double py = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTicks;
                double pz = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTicks;
                this.renderingvec = Vec3.func_72443_a((double)((double)this.mop.field_72311_b - px), (double)((double)this.mop.field_72312_c - py), (double)((double)this.mop.field_72309_d - pz));
                this.partialFrame = partialTicks;
            }
        }
    }

    public void clear() {
        this.set(null, null, null);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public MovingObjectPosition getPosition() {
        return this.mop;
    }

    @Override
    public Vec3 getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public NBTTagCompound getNBTData() {
        if (this.tileEntity != null && this.isTagCorrectTileEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.tileEntity != null) {
            NBTTagCompound tag = new NBTTagCompound();
            try {
                this.tileEntity.func_70310_b(tag);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            return tag;
        }
        if (this.entity != null) {
            NBTTagCompound tag = new NBTTagCompound();
            try {
                this.entity.func_70109_d(tag);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return tag;
        }
        return new NBTTagCompound();
    }

    public void setNBTData(NBTTagCompound tag) {
        if (tag != null) {
            this.remoteNbt = tag;
        }
    }

    private boolean isTagCorrectTileEntity(NBTTagCompound tag) {
        if (!(tag != null && tag.func_74764_b("WailaX") && tag.func_74764_b("WailaY") && tag.func_74764_b("WailaZ"))) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.func_74762_e("WailaX");
        int y = tag.func_74762_e("WailaY");
        int z = tag.func_74762_e("WailaZ");
        if (x == this.mop.field_72311_b && y == this.mop.field_72312_c && z == this.mop.field_72309_d) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.func_74762_e("WailaEntityID");
        if (id == this.entity.field_70157_k) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public int getNBTInteger(String keyname) {
        return this.getNBTInteger(this.getNBTData(), keyname);
    }

    @Override
    public int getNBTInteger(NBTTagCompound tag, String keyname) {
        return NBTUtil.getNBTInteger(tag, keyname);
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public ForgeDirection getSide() {
        return ForgeDirection.getOrientation((int)this.getPosition().field_72310_e);
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

