/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import mcp.mobius.waila.addons.ic2.IC2Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class HUDHandlerMatterGen
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerMatterGen();

    private HUDHandlerMatterGen() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("ic2.mattergen")) {
            try {
                String matterProgress = accessor.getNBTData().func_74779_i("matterProgress");
                String progressStr = I18n.translate("hud.msg.progress", new Object[0]);
                if (matterProgress != null && !matterProgress.isEmpty()) {
                    currenttip.add(progressStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + matterProgress);
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            String matterProgress = null;
            if (IC2Plugin.TileEntityMatter.isInstance(te)) {
                matterProgress = (String)IC2Plugin.TileEntityMatter_getProgressAsString.invoke((Object)te, new Object[0]);
            }
            if (matterProgress != null) {
                tag.func_74778_a("matterProgress", matterProgress);
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, te.getClass(), null);
        }
    }
}

