/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.ModIdentification;
import mcp.mobius.waila.utils.SpawnUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EnumSkyBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public final class HUDHandlerBlocks
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerBlocks();

    private HUDHandlerBlocks() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            String s = DisplayUtil.itemDisplayNameShort(itemStack);
            String name = null;
            if (s != null && !s.endsWith("Unnamed")) {
                name = s;
            }
            if (name != null) {
                currenttip.add(name);
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (currenttip.isEmpty()) {
            currenttip.add(I18n.translate("hud.msg.please_report", new Object[0]));
        }
        if (PluginConfig.instance().get("general", "waila.cfg.metadata", true)) {
            currenttip.add("\u00a7oID " + accessor.getBlockID() + ":" + accessor.getMetadata());
        }
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        Block b = accessor.getBlock();
        int meta = accessor.getMetadata();
        World w = accessor.getWorld();
        int x = accessor.getPosition().field_72311_b;
        int y = accessor.getPosition().field_72312_c;
        int z = accessor.getPosition().field_72309_d;
        if (config.get("general.harvest")) {
            String harvest = "hud.msg.please_report";
            if (b != null) {
                harvest = b.func_71934_m(w, x, y, z) < 0.0f ? "hud.msg.unbreakable" : (b.canHarvestBlock(accessor.getPlayer(), meta) ? "hud.msg.harvestable" : "hud.msg.not_harvestable");
            }
            currenttip.add(I18n.translate(harvest, new Object[0]));
        }
        if (config.get("general.lightlevel") && (!w.func_72887_b(x, y + 1, z, false) || w.func_72799_c(x, y + 1, z))) {
            int blockLightLevel = w.func_72972_b(EnumSkyBlock.Block, x, y + 1, z);
            byte spawnMode = SpawnUtil.getSpawnMode(w, x, y + 1, z);
            String blockLight = (spawnMode == 0 ? "\u00a7a" : (spawnMode == 1 ? "\u00a7e" : "\u00a74")) + blockLightLevel;
            String skyLight = w.func_72972_b(EnumSkyBlock.Sky, x, y + 1, z) + "";
            currenttip.add(I18n.translate("hud.msg.light_level", new Object[0]) + ": " + blockLight + "\u00a7e" + " (" + skyLight + ")");
        }
        if (config.get("general.break")) {
            try {
                float curBlockDamage = CorePlugin.curBlockDamageMP.getFloat(Minecraft.func_71410_x().field_71442_b);
                if (curBlockDamage > 0.0f) {
                    String progress = MathHelper.func_76141_d((float)(100.0f * curBlockDamage)) + "%";
                    currenttip.add(I18n.translate("hud.msg.break_progression", new Object[0]) + ": " + progress);
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, "curBlockDamageMP", currenttip);
            }
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        String modName = ModIdentification.nameFromStack(itemStack);
        if (!modName.isEmpty()) {
            currenttip.add("\u00a79\u00a7o" + modName);
        }
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        if (te != null) {
            te.func_70310_b(tag);
        }
    }
}

