/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.cc;

import mcp.mobius.waila.addons.cc.ChickenChunksPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public final class HUDHandlerChunkLoader
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerChunkLoader();

    private HUDHandlerChunkLoader() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        TileEntity te = accessor.getTileEntity();
        if (config.get("cc.owner")) {
            currenttip.add(I18n.translate("hud.msg.owner", new Object[0]) + ": " + accessor.getNBTData().func_74779_i("owner"));
        }
        if (config.get("cc.active")) {
            String on = accessor.getNBTData().func_74767_n("active") ? I18n.translate("hud.msg.on", new Object[0]) : I18n.translate("hud.msg.off", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + on);
        }
        if (config.get("cc.radius")) {
            try {
                if (ChickenChunksPlugin.TileChunkLoader.isInstance(te)) {
                    int radius = accessor.getNBTInteger("radius");
                    currenttip.add(I18n.translate("hud.msg.radius", new Object[0]) + ": " + radius + " " + (radius == 1 ? I18n.translate("hud.msg.chunk", new Object[0]) : I18n.translate("hud.msg.chunks", new Object[0])));
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
        if (config.get("cc.shape")) {
            try {
                if (ChickenChunksPlugin.TileChunkLoader.isInstance(te)) {
                    currenttip.add(I18n.translate("hud.msg.shape", new Object[0]) + ": " + accessor.getNBTData().func_74779_i("shapeStr"));
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            tag.func_74757_a("active", ChickenChunksPlugin.TileChunkLoaderBase_active.getBoolean(te));
            if (ChickenChunksPlugin.TileChunkLoader.isInstance(te)) {
                tag.func_74778_a("shapeStr", ChickenChunksPlugin.TileChunkLoader_shape.get(te).toString());
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

