/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.barrels;

import mcp.mobius.waila.addons.barrels.BarrelsPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public final class HUDHandlerBarrels
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerBarrels();

    private HUDHandlerBarrels() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (BarrelsPlugin.TileEntityBarrel.isInstance(accessor.getTileEntity())) {
            int itemID = accessor.getNBTInteger("item");
            ItemStack stored = null;
            if (itemID > 0 && Item.field_77698_e[itemID] != null) {
                stored = new ItemStack(itemID, accessor.getNBTInteger("size"), accessor.getNBTInteger("metadata"));
            }
            if (stored != null) {
                if (accessor.getNBTData().func_74764_b("tag")) {
                    stored.func_77982_d(accessor.getNBTData().func_74775_l("tag"));
                }
                if (config.get("barrels.itemtype")) {
                    currenttip.add(DisplayUtil.itemDisplayNameShortUnformatted(stored));
                }
                if (config.get("barrels.itemnumb")) {
                    try {
                        currenttip.add(stored.field_77994_a + " / " + accessor.getNBTInteger("invSize") + " " + I18n.translate("hud.msg.items", new Object[0]));
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
                    }
                }
            } else if (config.get("barrels.itemtype")) {
                currenttip.add(I18n.translate("hud.msg.empty", new Object[0]));
            }
            if (config.get("barrels.space")) {
                currenttip.add(accessor.getNBTInteger("stackLimit") + " " + I18n.translate("hud.msg.stacks", new Object[0]) + " max");
            }
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        if (BarrelsPlugin.TileEntityBarrel.isInstance(accessor.getTileEntity())) {
            try {
                int itemID = tag.func_74762_e("item");
                if (itemID > 0 && Item.field_77698_e[itemID] != null) {
                    int invSize = (Integer)BarrelsPlugin.TileEntityBarrel_getInventorySize.invoke((Object)accessor.getTileEntity(), new Object[0]);
                    tag.func_74768_a("invSize", invSize);
                }
                int stackLimit = (Integer)BarrelsPlugin.TileEntityBarrel_getStackLimit.invoke((Object)accessor.getTileEntity(), new Object[0]);
                tag.func_74768_a("stackLimit", stackLimit);
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
            }
        }
    }
}

