/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.advmachines;

import mcp.mobius.waila.addons.advmachines.AdvMachinesPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public final class HUDHandlerAdvGenerator
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerAdvGenerator();

    private HUDHandlerAdvGenerator() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            int storage = accessor.getNBTInteger("storage");
            int maxStorage = accessor.getNBTInteger("maxStorage");
            String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
            if (config.get("advmachines.storage") && maxStorage > 0) {
                currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(storage, maxStorage) + "\u00a7r" + " / " + "\u00a7f" + maxStorage + "\u00a7r" + " EU");
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            int storage = -1;
            int maxStorage = -1;
            if (AdvMachinesPlugin.TileAM2BaseGenerator.isInstance(te)) {
                storage = AdvMachinesPlugin.TileAM2BaseGenerator_stored.getInt(te);
                maxStorage = AdvMachinesPlugin.TileAM2BaseGenerator_maxStorage.getInt(null);
            }
            tag.func_74768_a("storage", storage);
            tag.func_74768_a("maxStorage", maxStorage);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

