/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ArgsWrapper;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public abstract class MinecraftServer
implements ab,
Runnable,
mc {
    private static MinecraftServer k = null;
    private final aki l;
    private final ma m = new ma("server", this);
    private final File n;
    private final List o = new ArrayList();
    private final aa p;
    public final la a = new la();
    private String q;
    private int r = -1;
    public iz[] b = new iz[0];
    private gu s;
    private boolean t = true;
    private boolean u = false;
    private int v = 0;
    public String c;
    public int d;
    private boolean w;
    private boolean x;
    private boolean y;
    private boolean z;
    private boolean A;
    private String B;
    private int C;
    private long D;
    private long E;
    private long F;
    private long G;
    public final long[] e = new long[100];
    public final long[] f = new long[100];
    public final long[] g = new long[100];
    public final long[] h = new long[100];
    public final long[] i = new long[100];
    public Hashtable<Integer, long[]> worldTickTimes = new Hashtable();
    private KeyPair H;
    private String I;
    private String J;
    @SideOnly(value=Side.CLIENT)
    private String K;
    private boolean L;
    private boolean M;
    private boolean N;
    private String O = "";
    private boolean P = false;
    private long Q;
    private String R;
    private boolean S;
    private boolean T = false;

    public MinecraftServer(File par1File) {
        k = this;
        this.n = par1File;
        this.p = new hs();
        this.l = new ajq(par1File);
        this.an();
    }

    private void an() {
        fx.a();
    }

    protected abstract boolean c() throws IOException;

    protected void b(String par1Str) {
        if (this.N().b(par1Str)) {
            this.al().a("Converting map!");
            this.c("menu.convertingLevel");
            this.N().a(par1Str, new gn(this));
        }
    }

    protected synchronized void c(String par1Str) {
        this.R = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public synchronized String d() {
        return this.R;
    }

    protected void a(String par1Str, String par2Str, long par3, aal par5WorldType, String par6Str) {
        aai worldsettings;
        this.b(par1Str);
        this.c("menu.loadingLevel");
        akf isavehandler = this.l.a(par1Str, true);
        ajv worldinfo = isavehandler.d();
        if (worldinfo == null) {
            worldsettings = new aai(par3, this.g(), this.f(), this.i(), par5WorldType);
            worldsettings.a(par6Str);
        } else {
            worldsettings = new aai(worldinfo);
        }
        if (this.M) {
            worldsettings.a();
        }
        iz overWorld = this.M() ? new iq(this, isavehandler, par2Str, 0, this.a, this.al()) : new iz(this, isavehandler, par2Str, 0, worldsettings, this.a, this.al());
        Integer[] arr$ = DimensionManager.getStaticDimensionIDs();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int dim = arr$[i$];
            iz world = dim == 0 ? overWorld : new is(this, isavehandler, par2Str, dim, worldsettings, overWorld, this.a, this.al());
            world.a(new iv(this, world));
            if (!this.I()) {
                world.M().a(this.g());
            }
            this.s.a(this.b);
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        }
        this.s.a(new iz[]{overWorld});
        this.c(this.h());
        this.e();
    }

    protected void e() {
        int i2 = 0;
        this.c("menu.generatingTerrain");
        int b0 = 0;
        this.al().a("Preparing start region for level " + b0);
        iz worldserver = this.b[b0];
        t chunkcoordinates = worldserver.J();
        long j2 = System.currentTimeMillis();
        for (int k2 = -192; k2 <= 192 && this.m(); k2 += 16) {
            for (int l2 = -192; l2 <= 192 && this.m(); l2 += 16) {
                long i1 = System.currentTimeMillis();
                if (i1 - j2 > 1000L) {
                    this.a_("Preparing spawn area", i2 * 100 / 625);
                    j2 = i1;
                }
                ++i2;
                worldserver.b.c(chunkcoordinates.a + k2 >> 4, chunkcoordinates.c + l2 >> 4);
            }
        }
        this.j();
    }

    public abstract boolean f();

    public abstract aaj g();

    public abstract int h();

    public abstract boolean i();

    protected void a_(String par1Str, int par2) {
        this.c = par1Str;
        this.d = par2;
        this.al().a(par1Str + ": " + par2 + "%");
    }

    protected void j() {
        this.c = null;
        this.d = 0;
    }

    protected void a(boolean par1) {
        if (!this.N) {
            iz[] aworldserver = this.b;
            if (aworldserver == null) {
                return;
            }
            for (iz worldserver : aworldserver) {
                if (worldserver == null) continue;
                if (!par1) {
                    this.al().a("Saving chunks for level '" + worldserver.M().k() + "'/" + worldserver.t.l());
                }
                try {
                    worldserver.a(true, (lc)null);
                }
                catch (aaf minecraftexception) {
                    this.al().b(minecraftexception.getMessage());
                }
            }
        }
    }

    public void k() {
        if (!this.N) {
            iz[] tmp;
            this.al().a("Stopping server");
            if (this.ae() != null) {
                this.ae().a();
            }
            if (this.s != null) {
                this.al().a("Saving players");
                this.s.g();
                this.s.r();
            }
            this.al().a("Saving worlds");
            this.a(false);
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                iz worldserver = this.b[i2];
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(worldserver));
                worldserver.n();
            }
            for (iz world : tmp = this.b) {
                DimensionManager.setWorld(world.t.h, null);
            }
            if (this.m != null && this.m.d()) {
                this.m.e();
            }
        }
    }

    public String l() {
        return this.q;
    }

    public void d(String par1Str) {
        this.q = par1Str;
    }

    public boolean m() {
        return this.t;
    }

    public void n() {
        this.t = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long j2;
        long i2;
        try {
            if (!this.c()) {
                this.a((b)null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            i2 = System.currentTimeMillis();
            FMLCommonHandler.instance().onWorldLoadTick(this.b);
            j2 = 0L;
        }
        catch (Throwable throwable) {
            if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                return;
            }
            throwable.printStackTrace();
            this.al().c("Encountered an unexpected exception " + throwable.getClass().getSimpleName(), throwable);
            b crashreport = null;
            crashreport = throwable instanceof u ? this.b(((u)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File file1 = new File(new File(this.o(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.a(file1, this.al())) {
                this.al().c("This crash report has been saved to: " + file1.getAbsolutePath());
            } else {
                this.al().c("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                    return;
                }
                this.k();
                this.u = true;
            }
            catch (Throwable throwable1) {
                throwable1.printStackTrace();
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.u = true;
                this.p();
            }
        }
        while (true) {
            if (!this.t) {
                FMLCommonHandler.instance().handleServerStopping();
                return;
            }
            long k2 = System.currentTimeMillis();
            long l2 = k2 - i2;
            if (l2 > 2000L && i2 - this.Q >= 15000L) {
                this.al().b("Can't keep up! Did the system time change, or is the server overloaded?");
                l2 = 2000L;
                this.Q = i2;
            }
            if (l2 < 0L) {
                this.al().b("Time ran backwards! Did the system time change?");
                l2 = 0L;
            }
            j2 += l2;
            i2 = k2;
            if (this.b[0].e()) {
                this.q();
                j2 = 0L;
            } else {
                while (j2 > 50L) {
                    j2 -= 50L;
                    this.q();
                }
            }
            Thread.sleep(1L);
            this.P = true;
        }
    }

    protected File o() {
        return new File(".");
    }

    protected void a(b par1CrashReport) {
    }

    protected void p() {
    }

    public void q() {
        FMLCommonHandler.instance().rescheduleTicks(Side.SERVER);
        long i2 = System.nanoTime();
        aqx.a().a();
        FMLCommonHandler.instance().onPreServerTick();
        ++this.v;
        if (this.S) {
            this.S = false;
            this.a.a = true;
            this.a.a();
        }
        this.a.a("root");
        this.r();
        if (this.v % 900 == 0) {
            this.a.a("save");
            this.s.g();
            this.a(true);
            this.a.b();
        }
        this.a.a("tallying");
        this.i[this.v % 100] = System.nanoTime() - i2;
        this.e[this.v % 100] = ei.q - this.D;
        this.D = ei.q;
        this.f[this.v % 100] = ei.r - this.E;
        this.E = ei.r;
        this.g[this.v % 100] = ei.o - this.F;
        this.F = ei.o;
        this.h[this.v % 100] = ei.p - this.G;
        this.G = ei.p;
        this.a.b();
        this.a.a("snooper");
        if (!this.m.d() && this.v > 100) {
            this.m.a();
        }
        if (this.v % 6000 == 0) {
            this.m.b();
        }
        this.a.b();
        this.a.b();
        FMLCommonHandler.instance().onPostServerTick();
    }

    public void r() {
        this.a.a("levels");
        Integer[] ids = DimensionManager.getIDs(this.v % 200 == 0);
        for (int x2 = 0; x2 < ids.length; ++x2) {
            int id2 = ids[x2];
            long j2 = System.nanoTime();
            if (id2 == 0 || this.s()) {
                iz worldserver = DimensionManager.getWorld(id2);
                this.a.a(worldserver.M().k());
                this.a.a("pools");
                worldserver.U().a();
                this.a.b();
                if (this.v % 20 == 0) {
                    this.a.a("timeSync");
                    this.s.a(new fh(worldserver.H(), worldserver.I()), worldserver.t.h);
                    this.a.b();
                }
                this.a.a("tick");
                FMLCommonHandler.instance().onPreWorldTick(worldserver);
                try {
                    worldserver.b();
                }
                catch (Throwable throwable) {
                    b crashreport = b.a(throwable, "Exception ticking world");
                    worldserver.a(crashreport);
                    throw new u(crashreport);
                }
                try {
                    worldserver.h();
                }
                catch (Throwable throwable1) {
                    b crashreport = b.a(throwable1, "Exception ticking world entities");
                    worldserver.a(crashreport);
                    throw new u(crashreport);
                }
                FMLCommonHandler.instance().onPostWorldTick(worldserver);
                this.a.b();
                this.a.a("tracker");
                worldserver.q().a();
                this.a.b();
                this.a.b();
            }
            this.worldTickTimes.get((Object)Integer.valueOf((int)id2))[this.v % 100] = System.nanoTime() - j2;
        }
        this.a.c("dim_unloading");
        DimensionManager.unloadWorlds(this.worldTickTimes);
        this.a.c("connection");
        this.ae().b();
        this.a.c("players");
        this.s.b();
        this.a.c("tickables");
        for (int i2 = 0; i2 < this.o.size(); ++i2) {
            ((gy)this.o.get(i2)).a();
        }
        this.a.b();
    }

    public boolean s() {
        return true;
    }

    public void t() {
        new gp(this, "Server thread").start();
    }

    public File e(String par1Str) {
        return new File(this.o(), par1Str);
    }

    public void f(String par1Str) {
        this.al().a(par1Str);
    }

    public void g(String par1Str) {
        this.al().b(par1Str);
    }

    public iz a(int par1) {
        iz ret = DimensionManager.getWorld(par1);
        if (ret == null) {
            DimensionManager.initDimension(par1);
            ret = DimensionManager.getWorld(par1);
        }
        return ret;
    }

    @SideOnly(value=Side.SERVER)
    public void a(gy par1IUpdatePlayerListBox) {
        this.o.add(par1IUpdatePlayerListBox);
    }

    public String u() {
        return this.q;
    }

    public int v() {
        return this.r;
    }

    public String w() {
        return this.B;
    }

    public String x() {
        return "1.5.2";
    }

    public int y() {
        return this.s.k();
    }

    public int z() {
        return this.s.l();
    }

    public String[] A() {
        return this.s.d();
    }

    public String B() {
        return "";
    }

    public String h(String par1Str) {
        jn.a.c();
        this.p.a(jn.a, par1Str);
        return jn.a.d();
    }

    public boolean C() {
        return false;
    }

    public void i(String par1Str) {
        this.al().c(par1Str);
    }

    public void j(String par1Str) {
        if (this.C()) {
            this.al().a(par1Str);
        }
    }

    public String getServerModName() {
        return FMLCommonHandler.instance().getModName();
    }

    public b b(b par1CrashReport) {
        par1CrashReport.g().a("Profiler Position", new gq(this));
        if (this.b != null && this.b.length > 0 && this.b[0] != null) {
            par1CrashReport.g().a("Vec3 Pool Size", new gr(this));
        }
        if (this.s != null) {
            par1CrashReport.g().a("Player Count", new gs(this));
        }
        return par1CrashReport;
    }

    public List a(ab par1ICommandSender, String par2Str) {
        ArrayList<String> arraylist = new ArrayList<String>();
        if (par2Str.startsWith("/")) {
            boolean flag = !(par2Str = par2Str.substring(1)).contains(" ");
            List list = this.p.b(par1ICommandSender, par2Str);
            if (list != null) {
                for (String s1 : list) {
                    if (flag) {
                        arraylist.add("/" + s1);
                        continue;
                    }
                    arraylist.add(s1);
                }
            }
            return arraylist;
        }
        String[] astring = par2Str.split(" ", -1);
        String s2 = astring[astring.length - 1];
        for (String s3 : this.s.d()) {
            if (!x.a(s2, s3)) continue;
            arraylist.add(s3);
        }
        return arraylist;
    }

    public static MinecraftServer D() {
        return k;
    }

    @Override
    public String c_() {
        return "Server";
    }

    @Override
    public void a(String par1Str) {
        this.al().a(lf.a(par1Str));
    }

    @Override
    public boolean a(int par1, String par2Str) {
        return true;
    }

    @Override
    public String a(String par1Str, Object ... par2ArrayOfObj) {
        return bp.a().a(par1Str, par2ArrayOfObj);
    }

    public aa E() {
        return this.p;
    }

    public KeyPair F() {
        return this.H;
    }

    public int G() {
        return this.r;
    }

    public void b(int par1) {
        this.r = par1;
    }

    public String H() {
        return this.I;
    }

    public void k(String par1Str) {
        this.I = par1Str;
    }

    public boolean I() {
        return this.I != null;
    }

    public String J() {
        return this.J;
    }

    public void l(String par1Str) {
        this.J = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public void m(String par1Str) {
        this.K = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public String K() {
        return this.K;
    }

    public void a(KeyPair par1KeyPair) {
        this.H = par1KeyPair;
    }

    public void c(int par1) {
        for (int j2 = 0; j2 < this.b.length; ++j2) {
            iz worldserver = this.b[j2];
            if (worldserver == null) continue;
            if (worldserver.M().t()) {
                worldserver.r = 3;
                worldserver.a(true, true);
                continue;
            }
            if (this.I()) {
                worldserver.r = par1;
                worldserver.a(worldserver.r > 0, true);
                continue;
            }
            worldserver.r = par1;
            worldserver.a(this.L(), this.x);
        }
    }

    protected boolean L() {
        return true;
    }

    public boolean M() {
        return this.L;
    }

    public void b(boolean par1) {
        this.L = par1;
    }

    public void c(boolean par1) {
        this.M = par1;
    }

    public aki N() {
        return this.l;
    }

    public void P() {
        this.N = true;
        this.N().d();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            iz worldserver = this.b[i2];
            if (worldserver == null) continue;
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(worldserver));
            worldserver.n();
        }
        this.N().e(this.b[0].L().g());
        this.n();
    }

    public String Q() {
        return this.O;
    }

    public void n(String par1Str) {
        this.O = par1Str;
    }

    @Override
    public void a(ma par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("whitelist_enabled", false);
        par1PlayerUsageSnooper.a("whitelist_count", 0);
        par1PlayerUsageSnooper.a("players_current", this.y());
        par1PlayerUsageSnooper.a("players_max", this.z());
        par1PlayerUsageSnooper.a("players_seen", this.s.m().length);
        par1PlayerUsageSnooper.a("uses_auth", this.w);
        par1PlayerUsageSnooper.a("gui_state", this.ag() ? "enabled" : "disabled");
        par1PlayerUsageSnooper.a("avg_tick_ms", (int)(kx.a(this.i) * 1.0E-6));
        par1PlayerUsageSnooper.a("avg_sent_packet_count", (int)kx.a(this.e));
        par1PlayerUsageSnooper.a("avg_sent_packet_size", (int)kx.a(this.f));
        par1PlayerUsageSnooper.a("avg_rec_packet_count", (int)kx.a(this.g));
        par1PlayerUsageSnooper.a("avg_rec_packet_size", (int)kx.a(this.h));
        int i2 = 0;
        for (int j2 = 0; j2 < this.b.length; ++j2) {
            if (this.b[j2] == null) continue;
            iz worldserver = this.b[j2];
            ajv worldinfo = worldserver.M();
            par1PlayerUsageSnooper.a("world[" + i2 + "][dimension]", worldserver.t.h);
            par1PlayerUsageSnooper.a("world[" + i2 + "][mode]", (Object)worldinfo.r());
            par1PlayerUsageSnooper.a("world[" + i2 + "][difficulty]", worldserver.r);
            par1PlayerUsageSnooper.a("world[" + i2 + "][hardcore]", worldinfo.t());
            par1PlayerUsageSnooper.a("world[" + i2 + "][generator_name]", worldinfo.u().a());
            par1PlayerUsageSnooper.a("world[" + i2 + "][generator_version]", worldinfo.u().c());
            par1PlayerUsageSnooper.a("world[" + i2 + "][height]", this.C);
            par1PlayerUsageSnooper.a("world[" + i2 + "][chunks_loaded]", worldserver.K().f());
            ++i2;
        }
        par1PlayerUsageSnooper.a("worlds", i2);
    }

    @Override
    public void b(ma par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("singleplayer", this.I());
        par1PlayerUsageSnooper.a("server_brand", this.getServerModName());
        par1PlayerUsageSnooper.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        par1PlayerUsageSnooper.a("dedicated", this.T());
    }

    @Override
    public boolean R() {
        return true;
    }

    public int S() {
        return 16;
    }

    public abstract boolean T();

    public boolean U() {
        return this.w;
    }

    public void d(boolean par1) {
        this.w = par1;
    }

    public boolean V() {
        return this.x;
    }

    public void e(boolean par1) {
        this.x = par1;
    }

    public boolean W() {
        return this.y;
    }

    public void f(boolean par1) {
        this.y = par1;
    }

    public boolean X() {
        return this.z;
    }

    public void g(boolean par1) {
        this.z = par1;
    }

    public boolean Y() {
        return this.A;
    }

    public void h(boolean par1) {
        this.A = par1;
    }

    public abstract boolean Z();

    public String aa() {
        return this.B;
    }

    public void o(String par1Str) {
        this.B = par1Str;
    }

    public int ab() {
        return this.C;
    }

    public void d(int par1) {
        this.C = par1;
    }

    public boolean ac() {
        return this.u;
    }

    public gu ad() {
        return this.s;
    }

    public void a(gu par1ServerConfigurationManager) {
        this.s = par1ServerConfigurationManager;
    }

    public void a(aaj par1EnumGameType) {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            MinecraftServer.D().b[i2].M().a(par1EnumGameType);
        }
    }

    public abstract jk ae();

    @SideOnly(value=Side.CLIENT)
    public boolean af() {
        return this.P;
    }

    public boolean ag() {
        return false;
    }

    public abstract String a(aaj var1, boolean var2);

    public int ah() {
        return this.v;
    }

    public void ai() {
        this.S = true;
    }

    @SideOnly(value=Side.CLIENT)
    public ma aj() {
        return this.m;
    }

    @Override
    public t b() {
        return new t(0, 0, 0);
    }

    public int ak() {
        return 16;
    }

    public boolean a(aab par1World, int par2, int par3, int par4, sq par5EntityPlayer) {
        return false;
    }

    @Override
    public abstract ku al();

    public void i(boolean par1) {
        this.T = par1;
    }

    public boolean am() {
        return this.T;
    }

    public static gu a(MinecraftServer par0MinecraftServer) {
        return par0MinecraftServer.s;
    }

    @SideOnly(value=Side.SERVER)
    public static void main(String[] par0ArrayOfStr) {
        FMLRelauncher.handleServerRelaunch(new ArgsWrapper(par0ArrayOfStr));
    }

    @SideOnly(value=Side.SERVER)
    public static void fmlReentry(ArgsWrapper wrap) {
        String[] par0ArrayOfStr = wrap.args;
        kf.a();
        ku ilogagent = null;
        try {
            boolean flag = !GraphicsEnvironment.isHeadless();
            String s2 = null;
            String s1 = ".";
            String s22 = null;
            boolean flag1 = false;
            boolean flag2 = false;
            int i2 = -1;
            for (int j2 = 0; j2 < par0ArrayOfStr.length; ++j2) {
                String s3 = par0ArrayOfStr[j2];
                String s4 = j2 == par0ArrayOfStr.length - 1 ? null : par0ArrayOfStr[j2 + 1];
                boolean flag3 = false;
                if (!s3.equals("nogui") && !s3.equals("--nogui")) {
                    if (s3.equals("--port") && s4 != null) {
                        flag3 = true;
                        try {
                            i2 = Integer.parseInt(s4);
                        }
                        catch (NumberFormatException numberformatexception) {}
                    } else if (s3.equals("--singleplayer") && s4 != null) {
                        flag3 = true;
                        s2 = s4;
                    } else if (s3.equals("--universe") && s4 != null) {
                        flag3 = true;
                        s1 = s4;
                    } else if (s3.equals("--world") && s4 != null) {
                        flag3 = true;
                        s22 = s4;
                    } else if (s3.equals("--demo")) {
                        flag1 = true;
                    } else if (s3.equals("--bonusChest")) {
                        flag2 = true;
                    }
                } else {
                    flag = false;
                }
                if (!flag3) continue;
                ++j2;
            }
            hz dedicatedserver = new hz(new File(s1));
            ilogagent = dedicatedserver.al();
            if (s2 != null) {
                dedicatedserver.k(s2);
            }
            if (s22 != null) {
                dedicatedserver.l(s22);
            }
            if (i2 >= 0) {
                dedicatedserver.b(i2);
            }
            if (flag1) {
                dedicatedserver.b(true);
            }
            if (flag2) {
                dedicatedserver.c(true);
            }
            if (flag) {
                dedicatedserver.ap();
            }
            dedicatedserver.t();
            Runtime.getRuntime().addShutdownHook((Thread)new go(dedicatedserver));
        }
        catch (Exception exception) {
            if (ilogagent != null) {
                ilogagent.c("Failed to start the minecraft server", exception);
            }
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }
}

