/*
 * Decompiled with CFR 0.152.
 */
import bspkrs.client.util.HUDUtils;
import bspkrs.util.BSProp;
import bspkrs.util.BSPropRegistry;
import bspkrs.util.ModVersionChecker;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class mod_StatusEffectHUD
extends BaseMod {
    protected float zLevel = 0.0f;
    private axs scaledResolution;
    @BSProp(info="Valid alignment strings are topleft, topcenter, topright, middleleft, middlecenter, middleright, bottomleft, bottomcenter (not recommended), bottomright")
    public static String alignMode = "topleft";
    @BSProp(info="Set to true to see the effect background box, false to disable")
    public static boolean enableBackground = false;
    @BSProp(info="Set to true to show effect names, false to disable")
    public static boolean enableEffectName = true;
    @BSProp(info="Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png)")
    public static String effectNameColor = "f";
    @BSProp(info="Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png)")
    public static String durationColor = "f";
    @BSProp(info="Horizontal offset from the edge of the screen (when using right alignments the x offset is relative to the right edge of the screen)")
    public static int xOffset = 2;
    @BSProp(info="Vertical offset from the edge of the screen (when using bottom alignments the y offset is relative to the bottom edge of the screen)")
    public static int yOffset = 2;
    @BSProp(info="Vertical offset used only for the bottomcenter alignment to avoid the vanilla HUD")
    public static int yOffsetBottomCenter = 41;
    @BSProp(info="Set to true if you want the xOffset value to be applied when using a center alignment")
    public static boolean applyXOffsetToCenter = false;
    @BSProp(info="Set to true if you want the yOffset value to be applied when using a middle alignment")
    public static boolean applyYOffsetToMiddle = false;
    @BSProp(info="Set to true to show info when chat is open, false to disable info when chat is open\n\n**ONLY EDIT WHAT IS BELOW THIS**")
    public static boolean showInChat = true;
    private ModVersionChecker versionChecker;
    private boolean allowUpdateCheck;
    private final String versionURL = "http://bspk.rs/Minecraft/1.5.2/statusEffectHUD.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/1114612-";

    public mod_StatusEffectHUD() {
        BSPropRegistry.registerPropHandler(this.getClass());
    }

    @Override
    public String getName() {
        return "StatusEffectHUD";
    }

    @Override
    public String getVersion() {
        return "v1.10(1.5.2)";
    }

    @Override
    public String getPriorities() {
        return "required-after:mod_bspkrsCore";
    }

    @Override
    public void load() {
        this.allowUpdateCheck = mod_bspkrsCore.allowUpdateCheck;
        if (this.allowUpdateCheck) {
            this.versionChecker = new ModVersionChecker(this.getName(), this.getVersion(), "http://bspk.rs/Minecraft/1.5.2/statusEffectHUD.version", "http://www.minecraftforum.net/topic/1114612-");
            this.versionChecker.checkVersionWithLogging();
        }
        ModLoader.setInGameHook(this, true, false);
    }

    @Override
    public boolean onTickInGame(float f2, Minecraft mc2) {
        if ((mc2.H || mc2.s == null || mc2.s instanceof awj && showInChat) && !mc2.z.ab && !mc2.z.T.e) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc2.p.a();
            this.scaledResolution = new axs(mc2.z, mc2.c, mc2.d);
            this.displayStatusEffects(mc2);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc2.p.a();
        }
        if (this.allowUpdateCheck && this.versionChecker != null) {
            if (!this.versionChecker.isCurrentVersion()) {
                for (String msg : this.versionChecker.getInGameMessage()) {
                    mc2.g.b(msg);
                }
            }
            this.allowUpdateCheck = false;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private int getX(int width) {
        if (alignMode.equalsIgnoreCase("topcenter") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("bottomcenter")) {
            return this.scaledResolution.a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("topright") || alignMode.equalsIgnoreCase("middleright") || alignMode.equalsIgnoreCase("bottomright")) {
            return this.scaledResolution.a() - width - xOffset;
        }
        return xOffset;
    }

    private int getY(int rowCount, int height) {
        if (alignMode.equalsIgnoreCase("middleleft") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("middleright")) {
            return this.scaledResolution.b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return this.scaledResolution.b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return this.scaledResolution.b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    private void displayStatusEffects(Minecraft mc2) {
        Collection activeEffects = mc2.g.bC();
        if (!activeEffects.isEmpty()) {
            int yOffset;
            int n2 = enableBackground ? 33 : (yOffset = enableEffectName ? 20 : 18);
            if (activeEffects.size() > 5 && enableBackground) {
                yOffset = 132 / (activeEffects.size() - 1);
            }
            int yBase = this.getY(activeEffects.size(), yOffset);
            for (ml potionEffect : activeEffects) {
                int potionStatusIcon;
                mk potion = mk.a[potionEffect.a()];
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc2.p.b("/gui/inventory.png");
                int xBase = this.getX(enableBackground ? 120 : 22 + mc2.q.a("0:00"));
                String potionName = "";
                if (enableEffectName) {
                    potionName = bo.a(potion.a());
                    if (potionEffect.c() == 1) {
                        potionName = potionName + " II";
                    } else if (potionEffect.c() == 2) {
                        potionName = potionName + " III";
                    } else if (potionEffect.c() == 3) {
                        potionName = potionName + " IV";
                    }
                    xBase = this.getX(enableBackground ? 120 : 22 + mc2.q.a(potionName));
                }
                String effectDuration = mk.a(potionEffect);
                if (enableBackground) {
                    HUDUtils.drawTexturedModalRect(xBase, yBase, 0, 166, 140, 32, this.zLevel);
                }
                if (alignMode.toLowerCase().contains("right")) {
                    xBase = this.getX(0);
                    if (potion.d()) {
                        potionStatusIcon = potion.e();
                        HUDUtils.drawTexturedModalRect(xBase + (enableBackground ? -24 : -18), yBase + (enableBackground ? 7 : 0), 0 + potionStatusIcon % 8 * 18, 198 + potionStatusIcon / 8 * 18, 18, 18, this.zLevel);
                    }
                    int stringWidth = mc2.q.a(potionName);
                    mc2.q.a("\u00a7" + effectNameColor + potionName + "\u00a7r", xBase + (enableBackground ? -10 : -4) - 18 - stringWidth, yBase + (enableBackground ? 6 : 0), 0xFFFFFF);
                    stringWidth = mc2.q.a(effectDuration);
                    mc2.q.a("\u00a7" + durationColor + effectDuration + "\u00a7r", xBase + (enableBackground ? -10 : -4) - 18 - stringWidth, yBase + (enableBackground ? 6 : 0) + (enableEffectName ? 10 : 5), 0xFFFFFF);
                } else {
                    if (potion.d()) {
                        potionStatusIcon = potion.e();
                        HUDUtils.drawTexturedModalRect(xBase + (enableBackground ? 6 : 0), yBase + (enableBackground ? 7 : 0), 0 + potionStatusIcon % 8 * 18, 198 + potionStatusIcon / 8 * 18, 18, 18, this.zLevel);
                    }
                    mc2.q.a("\u00a7" + effectNameColor + potionName + "\u00a7r", xBase + (enableBackground ? 10 : 4) + 18, yBase + (enableBackground ? 6 : 0), 0xFFFFFF);
                    mc2.q.a("\u00a7" + durationColor + effectDuration + "\u00a7r", xBase + (enableBackground ? 10 : 4) + 18, yBase + (enableBackground ? 6 : 0) + (enableEffectName ? 10 : 5), 0xFFFFFF);
                }
                yBase += yOffset;
            }
        }
    }
}

