/*
 * Decompiled with CFR 0.152.
 */
import bspkrs.client.util.ColorThreshold;
import bspkrs.client.util.HUDUtils;
import bspkrs.util.BSProp;
import bspkrs.util.BSPropRegistry;
import bspkrs.util.ModVersionChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class mod_ArmorStatusHUD
extends BaseMod {
    private static final String DEFAULT_COLOR_LIST = "100,f; 80,7; 60,e; 40,6; 25,c; 10,4";
    @BSProp(info="Valid alignment strings are topleft, topcenter, topright, middleleft, middlecenter, middleright, bottomleft, bottomcenter, bottomright")
    public static String alignMode = "bottomleft";
    @BSProp(info="Set to true to show item names, false to disable")
    public static boolean enableItemName = false;
    @BSProp(info="Set to true to show the standard inventory item overlay (damage bar)")
    public static boolean showItemOverlay = true;
    @BSProp(info="This is a list of percent damage thresholds and text color codes that will be used when item damage is <= the threshold. Format used: \",\" separates the threshold and the color code, \";\" separates each pair. Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png)")
    public static String damageColorList = "100,f; 80,7; 60,e; 40,6; 25,c; 10,4";
    @BSProp(info="Valid damageDisplayType strings are value, percent, or none")
    public static String damageDisplayType = "value";
    @BSProp(info="Set to true to show the max damage when damageDisplayType=value")
    public static boolean showMaxDamage = false;
    @BSProp(info="Set to true to show info for your currently equipped item, false to disable")
    public static boolean showEquippedItem = true;
    @BSProp(info="Horizontal offset from the edge of the screen (when using right alignments the x offset is relative to the right edge of the screen)")
    public static int xOffset = 2;
    @BSProp(info="Vertical offset from the edge of the screen (when using bottom alignments the y offset is relative to the bottom edge of the screen)")
    public static int yOffset = 2;
    @BSProp(info="Vertical offset used only for the bottomcenter alignment to avoid the vanilla HUD")
    public static int yOffsetBottomCenter = 41;
    @BSProp(info="Set to true if you want the xOffset value to be applied when using a center alignment")
    public static boolean applyXOffsetToCenter = false;
    @BSProp(info="Set to true if you want the yOffset value to be applied when using a middle alignment")
    public static boolean applyYOffsetToMiddle = false;
    @BSProp(info="Set to true to show info when chat is open, false to disable info when chat is open\n\n**ONLY EDIT WHAT IS BELOW THIS**")
    public static boolean showInChat = false;
    private ModVersionChecker versionChecker;
    private boolean allowUpdateCheck;
    private final String versionURL = "http://bspk.rs/Minecraft/1.5.2/armorStatusHUD.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/1114612-";
    private static bhi itemRenderer = new bhi();
    protected float zLevel = 0.0f;
    private axs scaledResolution;
    private final List colorList;

    public mod_ArmorStatusHUD() {
        BSPropRegistry.registerPropHandler(this.getClass());
        this.colorList = new ArrayList();
    }

    @Override
    public String getName() {
        return "ArmorStatusHUD";
    }

    @Override
    public String getVersion() {
        return "v1.7(1.5.2)";
    }

    @Override
    public String getPriorities() {
        return "required-after:mod_bspkrsCore";
    }

    @Override
    public void load() {
        this.allowUpdateCheck = mod_bspkrsCore.allowUpdateCheck;
        if (this.allowUpdateCheck) {
            this.versionChecker = new ModVersionChecker(this.getName(), this.getVersion(), "http://bspk.rs/Minecraft/1.5.2/armorStatusHUD.version", "http://www.minecraftforum.net/topic/1114612-");
            this.versionChecker.checkVersionWithLogging();
        }
        try {
            for (String s2 : damageColorList.split(";")) {
                String[] ct2 = s2.split(",");
                this.colorList.add(new ColorThreshold(Integer.valueOf(ct2[0].trim()), ct2[1]));
            }
        }
        catch (Throwable e2) {
            ModLoader.getLogger().log(Level.WARNING, "Error encountered parsing damageColorList: " + damageColorList);
            ModLoader.getLogger().log(Level.WARNING, "Reverting to defaultColorList: 100,f; 80,7; 60,e; 40,6; 25,c; 10,4");
            for (String s3 : DEFAULT_COLOR_LIST.split(";")) {
                String[] ct3 = s3.split(",");
                this.colorList.add(new ColorThreshold(Integer.valueOf(ct3[0]), ct3[1]));
            }
        }
        Collections.sort(this.colorList);
        ModLoader.setInGameHook(this, true, false);
    }

    @Override
    public boolean onTickInGame(float f2, Minecraft mc2) {
        if ((mc2.H || mc2.s == null || mc2.s instanceof awj && showInChat) && !mc2.z.ab && !mc2.z.T.e) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc2.p.a();
            this.scaledResolution = new axs(mc2.z, mc2.c, mc2.d);
            this.displayArmorStatus(mc2);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc2.p.a();
        }
        if (this.allowUpdateCheck) {
            if (!this.versionChecker.isCurrentVersion()) {
                for (String msg : this.versionChecker.getInGameMessage()) {
                    mc2.g.b(msg);
                }
            }
            this.allowUpdateCheck = false;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private int getX(int width) {
        if (alignMode.toLowerCase().contains("center")) {
            return this.scaledResolution.a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.toLowerCase().contains("right")) {
            return this.scaledResolution.a() - width - xOffset;
        }
        return xOffset;
    }

    private int getY(int rowCount, int height) {
        if (alignMode.toLowerCase().contains("middle")) {
            return this.scaledResolution.b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return this.scaledResolution.b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return this.scaledResolution.b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    public static boolean playerHasArmorEquipped(sq player) {
        return player.bK.f(0) != null || player.bK.f(1) != null || player.bK.f(2) != null || player.bK.f(3) != null;
    }

    public static int countOfDisplayableItems(sq player) {
        int i2 = 0;
        i2 += mod_ArmorStatusHUD.canDisplayItem(player.bK.f(0)) ? 1 : 0;
        i2 += mod_ArmorStatusHUD.canDisplayItem(player.bK.f(1)) ? 1 : 0;
        i2 += mod_ArmorStatusHUD.canDisplayItem(player.bK.f(2)) ? 1 : 0;
        i2 += mod_ArmorStatusHUD.canDisplayItem(player.bK.f(3)) ? 1 : 0;
        return i2 += showEquippedItem && mod_ArmorStatusHUD.canDisplayItem(player.cd()) ? 1 : 0;
    }

    public static boolean canDisplayItem(wm item) {
        return item != null;
    }

    private void displayArmorStatus(Minecraft mc2) {
        if (mod_ArmorStatusHUD.playerHasArmorEquipped(mc2.g) || showEquippedItem && mod_ArmorStatusHUD.canDisplayItem(mc2.g.cd())) {
            int yOffset = enableItemName ? 18 : 16;
            int yBase = this.getY(mod_ArmorStatusHUD.countOfDisplayableItems(mc2.g), yOffset);
            for (int i2 = 3; i2 >= -1; --i2) {
                wm item = null;
                item = i2 == -1 && showEquippedItem ? mc2.g.cd() : (i2 != -1 ? mc2.g.bK.b[i2] : null);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!mod_ArmorStatusHUD.canDisplayItem(item)) continue;
                int xBase = 0;
                String itemDamage = "";
                if (item.g()) {
                    int maxDamage = item.l() + 1;
                    int damage = maxDamage - item.k();
                    if (damageDisplayType.equalsIgnoreCase("value")) {
                        itemDamage = "\u00a7" + ColorThreshold.getColorCode(this.colorList, damage * 100 / maxDamage) + damage + (showMaxDamage ? "/" + maxDamage : "");
                    } else if (damageDisplayType.equalsIgnoreCase("percent")) {
                        itemDamage = "\u00a7" + ColorThreshold.getColorCode(this.colorList, damage * 100 / maxDamage) + damage * 100 / maxDamage + "%";
                    }
                }
                xBase = this.getX(22 + mc2.q.a(HUDUtils.stripCtrl(itemDamage)));
                String itemName = "";
                if (enableItemName) {
                    itemName = bp.a().c(item.b().a());
                    xBase = this.getX(22 + mc2.q.a(itemName));
                }
                GL11.glEnable((int)32826);
                avb.b();
                avb.c();
                mod_ArmorStatusHUD.itemRenderer.f = 200.0f;
                if (alignMode.toLowerCase().contains("right")) {
                    xBase = this.getX(0);
                    itemRenderer.a(mc2.q, mc2.p, item, xBase - 18, yBase);
                    if (showItemOverlay) {
                        HUDUtils.renderItemOverlayIntoGUI(mc2.q, mc2.p, item, xBase - 18, yBase);
                    }
                    avb.a();
                    GL11.glDisable((int)32826);
                    int stringWidth = mc2.q.a(HUDUtils.stripCtrl(itemName));
                    mc2.q.a(itemName + "\u00a7r", xBase - 20 - stringWidth, yBase, 0xFFFFFF);
                    stringWidth = mc2.q.a(HUDUtils.stripCtrl(itemDamage));
                    mc2.q.a(itemDamage + "\u00a7r", xBase - 20 - stringWidth, yBase + (enableItemName ? 9 : 4), 0xFFFFFF);
                } else {
                    itemRenderer.a(mc2.q, mc2.p, item, xBase, yBase);
                    if (showItemOverlay) {
                        HUDUtils.renderItemOverlayIntoGUI(mc2.q, mc2.p, item, xBase, yBase);
                    }
                    avb.a();
                    GL11.glDisable((int)32826);
                    mc2.q.a(itemName + "\u00a7r", xBase + 20, yBase, 0xFFFFFF);
                    mc2.q.a(itemDamage + "\u00a7r", xBase + 20, yBase + (enableItemName ? 9 : 4), 0xFFFFFF);
                }
                yBase += yOffset;
            }
        }
    }
}

