/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.util.CommonUtils;
import bspkrs.util.Configuration;
import bspkrs.util.Property;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConfigCategory
implements Map {
    private String name;
    private String comment;
    private ArrayList children = new ArrayList();
    private Map properties = new TreeMap();
    public final ConfigCategory parent;
    private boolean changed = false;

    public ConfigCategory(String name) {
        this(name, null);
    }

    public ConfigCategory(String name, ConfigCategory parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigCategory) {
            ConfigCategory cat = (ConfigCategory)obj;
            return this.name.equals(cat.name) && this.children.equals(cat.children);
        }
        return false;
    }

    public String getQualifiedName() {
        return ConfigCategory.getQualifiedName(this.name, this.parent);
    }

    public static String getQualifiedName(String name, ConfigCategory parent) {
        return parent == null ? name : parent.getQualifiedName() + "." + name;
    }

    public ConfigCategory getFirstParent() {
        return this.parent == null ? this : this.parent.getFirstParent();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public Map getValues() {
        return this.properties;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Property get(String key) {
        return (Property)this.properties.get(key);
    }

    private void write(BufferedWriter out, String ... data) throws IOException {
        this.write(out, true, data);
    }

    private void write(BufferedWriter out, boolean new_line, String ... data) throws IOException {
        for (int x2 = 0; x2 < data.length; ++x2) {
            out.write(data[x2]);
        }
        if (new_line) {
            out.write(Configuration.NEW_LINE);
        }
    }

    public void write(BufferedWriter out, int indent) throws IOException {
        String pad0 = this.getIndent(indent);
        String pad1 = this.getIndent(indent + 1);
        String pad2 = this.getIndent(indent + 2);
        this.write(out, pad0, "####################################################################################################");
        this.write(out, pad0, "# ", this.name);
        if (this.comment != null) {
            this.write(out, pad0, "#===================================================================================================");
            for (String line : this.comment.split("\r?\n")) {
                this.write(out, pad0, "# ", line);
            }
        }
        this.write(out, pad0, "####################################################################################################", Configuration.NEW_LINE);
        if (!CommonUtils.isStringAllLettersOrDigits(this.name)) {
            this.name = '\"' + this.name + '\"';
        }
        this.write(out, pad0, this.name, " {");
        Property[] props = this.properties.values().toArray(new Property[this.properties.size()]);
        for (int x2 = 0; x2 < props.length; ++x2) {
            char type;
            String propName;
            Property prop = props[x2];
            if (prop.comment != null) {
                if (x2 != 0) {
                    out.newLine();
                }
                for (String commentLine : prop.comment.split("\r?\n")) {
                    this.write(out, pad1, "# ", commentLine);
                }
            }
            if (!CommonUtils.isStringAllLettersOrDigits(propName = prop.getName())) {
                propName = '\"' + propName + '\"';
            }
            if (prop.isList()) {
                type = prop.getType().getID();
                this.write(out, pad1, String.valueOf(type), ":", propName, " <");
                for (String line : prop.getStringList()) {
                    this.write(out, pad2, line);
                }
                this.write(out, pad1, " >");
                continue;
            }
            if (prop.getType() == null) {
                this.write(out, pad1, propName, "=", prop.getString());
                continue;
            }
            type = prop.getType().getID();
            this.write(out, pad1, String.valueOf(type), ":", propName, "=", prop.getString());
        }
        for (ConfigCategory child : this.children) {
            child.write(out, indent + 1);
        }
        this.write(out, pad0, "}", Configuration.NEW_LINE);
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder("");
        for (int x2 = 0; x2 < indent; ++x2) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (Property prop : this.properties.values()) {
            if (!prop.hasChanged()) continue;
            return true;
        }
        return false;
    }

    void resetChangedState() {
        this.changed = false;
        for (Property prop : this.properties.values()) {
            prop.resetChangedState();
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Property get(Object key) {
        return (Property)this.properties.get(key);
    }

    public Property put(String key, Property value) {
        this.changed = true;
        return this.properties.put(key, value);
    }

    public Property remove(Object key) {
        this.changed = true;
        return (Property)this.properties.remove(key);
    }

    public void putAll(Map m2) {
        this.changed = true;
        this.properties.putAll(m2);
    }

    @Override
    public void clear() {
        this.changed = true;
        this.properties.clear();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public Collection values() {
        return this.properties.values();
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }
}

