/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.util.BSLog;
import bspkrs.util.BSProp;
import bspkrs.util.BSProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;

public class BSPropHandler {
    private String cfgDir;
    private Class clazz;
    private String propFilename;
    private BSProperties props;
    private List propFields;
    private String comments;
    private int fieldsCheckSum;
    private int propsCheckSum;

    public BSPropHandler(String cfgDir, String propFilename, Class clazz) {
        this.cfgDir = cfgDir;
        this.propFilename = propFilename;
        this.clazz = clazz;
        try {
            this.synchPropsAndFields(false, true);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public BSPropHandler(String cfgDir, Class clazz) {
        this(cfgDir, clazz.getSimpleName() + ".bsprop.cfg", clazz);
    }

    private void readPropsFromFile() throws FileNotFoundException, IOException {
        this.props = new BSProperties();
        this.propsCheckSum = 0;
        File propFile = new File(this.cfgDir, this.propFilename);
        if (propFile.exists() && propFile.canRead()) {
            this.props.load(new FileInputStream(propFile));
        }
        if (this.props.containsKey("checksum")) {
            this.propsCheckSum = Integer.parseInt(this.props.getProperty("checksum"), 36);
        }
    }

    private void writePropsToFile() throws FileNotFoundException, IOException {
        File propFile = new File(this.cfgDir, this.propFilename);
        if (!this.props.isEmpty() && (propFile.exists() || propFile.createNewFile()) && propFile.canWrite()) {
            this.props.store(new FileOutputStream(propFile), this.comments);
        }
    }

    private void getPropFieldsListAndCheckSum() throws IllegalArgumentException, IllegalAccessException {
        this.propFields = new LinkedList();
        this.fieldsCheckSum = 0;
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!BSPropHandler.isFieldModifierPermissible(field.getModifiers()) || !field.isAnnotationPresent(BSProp.class)) continue;
            this.propFields.add(field);
            Object fieldValue = field.get(null);
            this.fieldsCheckSum += fieldValue.hashCode();
        }
    }

    public void updatePropsFromFields() throws IllegalArgumentException, IllegalAccessException, FileNotFoundException, IOException {
        this.synchPropsAndFields(true, false);
    }

    public void reloadPropsToFields() throws IllegalArgumentException, IllegalAccessException, FileNotFoundException, IOException {
        this.synchPropsAndFields(false, false);
    }

    public static boolean isFieldModifierPermissible(int modifier) {
        return Modifier.isStatic(modifier) && Modifier.isPublic(modifier) && !Modifier.isFinal(modifier);
    }

    private void synchPropsAndFields(boolean forceUpdatePropsFromFields, boolean isInitialCall) throws IllegalArgumentException, IllegalAccessException, FileNotFoundException, IOException {
        if (forceUpdatePropsFromFields && isInitialCall) {
            throw new IllegalArgumentException("Tried to call BSPropHandler.synchPropsAndFields() with both parameters == true.");
        }
        if (!forceUpdatePropsFromFields) {
            this.readPropsFromFile();
        } else {
            this.propsCheckSum = 0;
        }
        if (isInitialCall) {
            this.getPropFieldsListAndCheckSum();
        }
        StringBuilder commentSB = new StringBuilder();
        for (Field propField : this.propFields) {
            if (!BSPropHandler.isFieldModifierPermissible(propField.getModifiers()) || !propField.isAnnotationPresent(BSProp.class)) continue;
            Class<Object> fieldType = propField.getType();
            BSProp propAnnotation = propField.getAnnotation(BSProp.class);
            String propName = propAnnotation.name().length() != 0 ? propAnnotation.name() : propField.getName();
            Object fieldValue = propField.get(null);
            StringBuilder acceptableRangeSB = new StringBuilder();
            StringBuilder propInfoSB = new StringBuilder();
            if (isInitialCall) {
                if (propAnnotation.min() != Double.NEGATIVE_INFINITY) {
                    acceptableRangeSB.append(String.format(",>=%.1f", propAnnotation.min()));
                }
                if (propAnnotation.max() != Double.POSITIVE_INFINITY) {
                    acceptableRangeSB.append(String.format(",<=%.1f", propAnnotation.max()));
                }
                if (propAnnotation.info().length() > 0) {
                    propInfoSB.append(" -- ");
                    propInfoSB.append(propAnnotation.info());
                }
                commentSB.append(String.format("%s (%s:%s%s)%s\n", propName, fieldType.getName(), fieldValue, acceptableRangeSB, propInfoSB));
            }
            if (this.propsCheckSum == this.fieldsCheckSum && this.props.containsKey(propName)) {
                String existingPropValue = this.props.getProperty(propName);
                Object wrappedPropValue = null;
                if (fieldType.isAssignableFrom(String.class)) {
                    wrappedPropValue = existingPropValue;
                } else if (fieldType.isAssignableFrom(Integer.TYPE)) {
                    wrappedPropValue = Integer.parseInt(existingPropValue);
                } else if (fieldType.isAssignableFrom(Short.TYPE)) {
                    wrappedPropValue = Short.parseShort(existingPropValue);
                } else if (fieldType.isAssignableFrom(Byte.TYPE)) {
                    wrappedPropValue = Byte.parseByte(existingPropValue);
                } else if (fieldType.isAssignableFrom(Boolean.TYPE)) {
                    wrappedPropValue = Boolean.parseBoolean(existingPropValue);
                } else if (fieldType.isAssignableFrom(Float.TYPE)) {
                    wrappedPropValue = Float.valueOf(Float.parseFloat(existingPropValue));
                } else if (fieldType.isAssignableFrom(Double.TYPE)) {
                    wrappedPropValue = Double.parseDouble(existingPropValue);
                }
                if (wrappedPropValue == null) continue;
                if (wrappedPropValue instanceof Number) {
                    double doubleValue = ((Number)wrappedPropValue).doubleValue();
                    if (propAnnotation.min() != Double.NEGATIVE_INFINITY && doubleValue < propAnnotation.min()) {
                        BSLog.warning(String.format("%s: Value %n is less than the specified min (%n) for %s. Value set to %n.", this.clazz.getSimpleName(), doubleValue, propAnnotation.min(), propName, propAnnotation.min()), new Object[0]);
                        wrappedPropValue = propAnnotation.min();
                        this.props.setProperty(propName, wrappedPropValue.toString());
                    } else if (propAnnotation.max() != Double.POSITIVE_INFINITY && doubleValue > propAnnotation.max()) {
                        BSLog.warning(String.format("%s: Value %n is more than the specified max (%n) for %s. Value set to %n.", this.clazz.getSimpleName(), doubleValue, propAnnotation.max(), propName, propAnnotation.max()), new Object[0]);
                        wrappedPropValue = propAnnotation.max();
                        this.props.setProperty(propName, wrappedPropValue.toString());
                    }
                }
                BSLog.info("%s: %s set to %s", this.clazz.getSimpleName(), propName, wrappedPropValue);
                if (wrappedPropValue.equals(fieldValue)) continue;
                propField.set(null, wrappedPropValue);
                continue;
            }
            BSLog.info("%s: %s not in config, using field value: %s", this.clazz.getSimpleName(), propName, fieldValue);
            this.props.setProperty(propName, fieldValue.toString());
        }
        this.props.put("checksum", Integer.toString(this.fieldsCheckSum, 36));
        if (this.propsCheckSum != this.fieldsCheckSum) {
            this.propsCheckSum = this.fieldsCheckSum;
        }
        if (isInitialCall) {
            this.comments = commentSB.toString();
        }
        this.writePropsToFile();
    }
}

