/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum BSLog {
    INSTANCE;

    private Logger logger;

    public Logger getLogger() {
        if (this.logger == null) {
            this.init();
        }
        return this.logger;
    }

    private void init() {
        if (this.logger != null) {
            return;
        }
        this.logger = Logger.getLogger("bspkrsCore");
        this.logger.setParent(ModLoader.getLogger());
    }

    public static void info(String format, Object ... args) {
        INSTANCE.log(Level.INFO, format, args);
    }

    public static void log(Level level, Throwable exception, String format, Object ... args) {
        INSTANCE.getLogger().log(level, String.format(format, args), exception);
    }

    public static void severe(String format, Object ... args) {
        INSTANCE.log(Level.SEVERE, format, args);
    }

    public static void warning(String format, Object ... args) {
        INSTANCE.log(Level.WARNING, format, args);
    }

    private void log(Level level, String format, Object ... data) {
        this.getLogger().log(level, String.format(format, data));
    }
}

