/*
 * Decompiled with CFR 0.152.
 */
package MouseTweaks;

import MouseTweaks.DeobfuscationLayer;
import MouseTweaks.Logger;
import MouseTweaks.Reflection;

public class ModCompatibility
extends DeobfuscationLayer {
    private static boolean initialized = false;
    private static boolean forestryInstalled = false;
    private static boolean codechickencoreInstalled = false;
    private static boolean NEIInstalled = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        forestryInstalled = Reflection.reflectForestry();
        if (forestryInstalled) {
            Logger.Log("Successfully reflected Forestry!");
        }
        if (codechickencoreInstalled = Reflection.reflectCodeChickenCore()) {
            Logger.Log("Successfully reflected CodeChickenCore!");
        }
        if (NEIInstalled = Reflection.reflectNEI()) {
            Logger.Log("Successfully reflected NEI!");
        }
        initialized = true;
    }

    public static int getModGuiContainerID(axr guiScreen) {
        if (forestryInstalled && Reflection.forestry.isInstance("GuiForestry", guiScreen)) {
            return 2;
        }
        if (codechickencoreInstalled && Reflection.codechickencore.isInstance("GuiContainerWidget", guiScreen)) {
            return 3;
        }
        if (NEIInstalled && Reflection.NEI.isInstance("GuiRecipe", guiScreen) || Reflection.NEI.isInstance("GuiEnchantmentModifier", guiScreen)) {
            return 4;
        }
        return 0;
    }

    public static String getModNameFromModGuiContainerID(int id2) {
        switch (id2) {
            case 2: {
                return "Forestry";
            }
            case 3: {
                return "CodeChickenCore";
            }
            case 4: {
                return "NotEnoughItems";
            }
        }
        return "Unknown";
    }

    public static boolean isWheelDisabledForThisModContainer(int modGuiContainerID, axr guiScreen) {
        switch (modGuiContainerID) {
            default: 
        }
        return false;
    }

    public static ul modGetSlot(int modGuiContainerID, axr guiScreen, Object modContainer, int slotNumber) {
        switch (modGuiContainerID) {
            case 2: {
                return ModCompatibility.getSlot(ModCompatibility.asContainer(modContainer), slotNumber);
            }
            case 4: {
                return ModCompatibility.getSlot(ModCompatibility.asContainer(modContainer), slotNumber);
            }
        }
        return null;
    }

    public static boolean modIsCraftingOutputSlot(int modGuiContainerID, axr guiScreen, Object modContainer, ul selectedSlot) {
        switch (modGuiContainerID) {
            case 2: {
                return Reflection.is(modContainer, "ContainerSqueezer") && (ModCompatibility.getSlotNumber(selectedSlot) == 9 || ModCompatibility.getSlotNumber(selectedSlot) == 11) || Reflection.is(modContainer, "ContainerMoistener") && ModCompatibility.getSlotNumber(selectedSlot) == 9 || Reflection.is(modContainer, "ContainerCentrifuge") && ModCompatibility.getSlotNumber(selectedSlot) >= 1 && ModCompatibility.getSlotNumber(selectedSlot) <= 9 || Reflection.is(modContainer, "ContainerCarpenter") && ModCompatibility.getSlotNumber(selectedSlot) == 21 || Reflection.is(modContainer, "ContainerFabricator") && ModCompatibility.getSlotNumber(selectedSlot) == 20 || Reflection.is(modContainer, "ContainerWorktable") && ModCompatibility.getSlotNumber(selectedSlot) == 27;
            }
        }
        return false;
    }

    public static void modClickSlot(int modGuiContainerID, axr guiScreen, Object modContainer, ul targetSlot, int mouseButton, boolean shiftPressed) {
        switch (modGuiContainerID) {
            case 2: {
                Reflection.forestry.invokeMethod(guiScreen, "handleMouseClick", targetSlot, 0, mouseButton, shiftPressed ? 1 : 0);
                return;
            }
            case 4: {
                ModCompatibility.windowClick(ModCompatibility.getWindowId(ModCompatibility.asContainer(modContainer)), ModCompatibility.getSlotNumber(targetSlot), mouseButton, shiftPressed ? 1 : 0);
                return;
            }
        }
    }

    public static ul getModSelectedSlot(int modGuiContainerID, axr guiScreen, Object modContainer, int slotCount) {
        switch (modGuiContainerID) {
            case 2: {
                return ModCompatibility.asSlot(Reflection.forestry.invokeMethod(guiScreen, "getSlotAtPosition", ModCompatibility.getRequiredMouseX(), ModCompatibility.getRequiredMouseY()));
            }
            case 4: {
                return ModCompatibility.getSelectedSlot(ModCompatibility.asGuiContainer(guiScreen), ModCompatibility.asContainer(modContainer), slotCount);
            }
        }
        return null;
    }

    public static int getModSlotCount(int modGuiContainerID, axr guiScreen, Object modContainer) {
        switch (modGuiContainerID) {
            case 2: {
                return ModCompatibility.getSlots(ModCompatibility.asContainer(modContainer)).size();
            }
            case 4: {
                return ModCompatibility.getSlots(ModCompatibility.asContainer(modContainer)).size();
            }
        }
        return 0;
    }

    public static Object getModContainer(int modGuiContainerID, axr guiScreen) {
        switch (modGuiContainerID) {
            case 2: {
                return Reflection.forestry.getFieldValue("inventorySlots", guiScreen);
            }
            case 4: {
                return ModCompatibility.getContainer(ModCompatibility.asGuiContainer(guiScreen));
            }
        }
        return null;
    }

    public static void disableRMBDragIfRequired(int guiContainerID, axr guiScreen, Object modContainer, ul firstSlot, boolean shouldClick) {
        switch (guiContainerID) {
            case 4: {
                ModCompatibility.disableVanillaRMBDrag(ModCompatibility.asGuiContainer(guiScreen));
                if (shouldClick) {
                    ModCompatibility.modClickSlot(guiContainerID, guiScreen, modContainer, firstSlot, 1, false);
                }
                return;
            }
        }
    }

    public static boolean isDisabledForThisModContainer(int guiContainerID, axr guiScreen, Object container) {
        switch (guiContainerID) {
            case 3: {
                return true;
            }
            case 4: {
                return !Reflection.NEI.isInstance("GuiEnchantmentModifier", guiScreen);
            }
        }
        return false;
    }
}

