/*
 * Decompiled with CFR 0.152.
 */
package MouseTweaks;

import MouseTweaks.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;

public class Config {
    private String fileName;
    private HashMap Properties = new HashMap();

    public Config(String fileName) {
        this.fileName = fileName;
    }

    public boolean readConfig() {
        this.Properties.clear();
        try {
            File config = new File(this.fileName);
            if (!config.exists()) {
                return false;
            }
            FileReader fr2 = new FileReader(config);
            BufferedReader br2 = new BufferedReader(fr2);
            String strLine = "";
            while ((strLine = br2.readLine()) != null) {
                String[] strKeyValue = strLine.split("=");
                int l2 = strKeyValue.length;
                if (l2 < 2) continue;
                strKeyValue[0] = strKeyValue[0].trim();
                strKeyValue[1] = strKeyValue[1].trim();
                if (this.Properties.containsKey(strKeyValue[0])) {
                    Logger.Log("Duplicate property \"" + strKeyValue[0] + "\" in the config file, using the last value present");
                }
                this.Properties.put(strKeyValue[0], Integer.parseInt(strKeyValue[1]));
            }
            br2.close();
            fr2.close();
            int size = this.Properties.size();
            return size != 0;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public void saveConfig() {
        try {
            int size;
            File config = new File(this.fileName);
            if (!config.exists()) {
                config.getParentFile().mkdirs();
                config.createNewFile();
            }
            if ((size = this.Properties.size()) == 0) {
                return;
            }
            FileWriter fw = new FileWriter(config);
            BufferedWriter bw2 = new BufferedWriter(fw);
            for (String key : this.Properties.keySet()) {
                bw2.write(key + " = " + this.Properties.get(key) + "\n");
            }
            bw2.close();
            fw.close();
        }
        catch (Exception e2) {
            Logger.Log("Failed to write the config file: " + this.fileName);
            e2.printStackTrace();
        }
    }

    public int getOrCreatePropertyValue(String name, int defaultValue) {
        if (this.Properties.containsKey(name)) {
            return (Integer)this.Properties.get(name);
        }
        this.setPropertyValue(name, defaultValue);
        return defaultValue;
    }

    public int getPropertyValue(String name) {
        if (this.Properties.containsKey(name)) {
            return (Integer)this.Properties.get(name);
        }
        return 0;
    }

    public void setPropertyValue(String name, int value) {
        this.Properties.put(name, value);
    }
}

